<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeData pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfFeeData extends AbstractStructArrayBase
{
    /**
     * The FeeData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathFeeData[]
     */
    public $FeeData;
    /**
     * Constructor method for ArrayOfFeeData
     * @uses PathArrayOfFeeData::setFeeData()
     * @param \Path\pathStructType\PathFeeData[] $feeData
     */
    public function __construct(array $feeData = array())
    {
        $this
            ->setFeeData($feeData);
    }
    /**
     * Get FeeData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathFeeData[]|null
     */
    public function getFeeData()
    {
        return isset($this->FeeData) ? $this->FeeData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFeeData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeeData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeDataForArrayConstraintsFromSetFeeData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFeeDataFeeDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeeDataFeeDataItem instanceof \Path\pathStructType\PathFeeData) {
                $invalidValues[] = is_object($arrayOfFeeDataFeeDataItem) ? get_class($arrayOfFeeDataFeeDataItem) : sprintf('%s(%s)', gettype($arrayOfFeeDataFeeDataItem), var_export($arrayOfFeeDataFeeDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeeData property can only contain items of type \Path\pathStructType\PathFeeData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeeData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeData[] $feeData
     * @return \Path\pathArrayType\PathArrayOfFeeData
     */
    public function setFeeData(array $feeData = array())
    {
        // validation for constraint: array
        if ('' !== ($feeDataArrayErrorMessage = self::validateFeeDataForArrayConstraintsFromSetFeeData($feeData))) {
            throw new \InvalidArgumentException($feeDataArrayErrorMessage, __LINE__);
        }
        if (is_null($feeData) || (is_array($feeData) && empty($feeData))) {
            unset($this->FeeData);
        } else {
            $this->FeeData = $feeData;
        }
        return $this;
    }
    /**
     * Add item to FeeData value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeData $item
     * @return \Path\pathArrayType\PathArrayOfFeeData
     */
    public function addToFeeData(\Path\pathStructType\PathFeeData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathFeeData) {
            throw new \InvalidArgumentException(sprintf('The FeeData property can only contain items of type \Path\pathStructType\PathFeeData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FeeData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeeData
     */
    public function getAttributeName()
    {
        return 'FeeData';
    }
}
