<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeConfigured pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfFeeConfigured extends AbstractStructArrayBase
{
    /**
     * The FeeConfigured
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathFeeConfigured[]
     */
    public $FeeConfigured;
    /**
     * Constructor method for ArrayOfFeeConfigured
     * @uses PathArrayOfFeeConfigured::setFeeConfigured()
     * @param \Path\pathStructType\PathFeeConfigured[] $feeConfigured
     */
    public function __construct(array $feeConfigured = array())
    {
        $this
            ->setFeeConfigured($feeConfigured);
    }
    /**
     * Get FeeConfigured value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathFeeConfigured[]|null
     */
    public function getFeeConfigured()
    {
        return isset($this->FeeConfigured) ? $this->FeeConfigured : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFeeConfigured method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeeConfigured method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeConfiguredForArrayConstraintsFromSetFeeConfigured(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFeeConfiguredFeeConfiguredItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeeConfiguredFeeConfiguredItem instanceof \Path\pathStructType\PathFeeConfigured) {
                $invalidValues[] = is_object($arrayOfFeeConfiguredFeeConfiguredItem) ? get_class($arrayOfFeeConfiguredFeeConfiguredItem) : sprintf('%s(%s)', gettype($arrayOfFeeConfiguredFeeConfiguredItem), var_export($arrayOfFeeConfiguredFeeConfiguredItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeeConfigured property can only contain items of type \Path\pathStructType\PathFeeConfigured, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeeConfigured value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeConfigured[] $feeConfigured
     * @return \Path\pathArrayType\PathArrayOfFeeConfigured
     */
    public function setFeeConfigured(array $feeConfigured = array())
    {
        // validation for constraint: array
        if ('' !== ($feeConfiguredArrayErrorMessage = self::validateFeeConfiguredForArrayConstraintsFromSetFeeConfigured($feeConfigured))) {
            throw new \InvalidArgumentException($feeConfiguredArrayErrorMessage, __LINE__);
        }
        if (is_null($feeConfigured) || (is_array($feeConfigured) && empty($feeConfigured))) {
            unset($this->FeeConfigured);
        } else {
            $this->FeeConfigured = $feeConfigured;
        }
        return $this;
    }
    /**
     * Add item to FeeConfigured value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeConfigured $item
     * @return \Path\pathArrayType\PathArrayOfFeeConfigured
     */
    public function addToFeeConfigured(\Path\pathStructType\PathFeeConfigured $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathFeeConfigured) {
            throw new \InvalidArgumentException(sprintf('The FeeConfigured property can only contain items of type \Path\pathStructType\PathFeeConfigured, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FeeConfigured[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathFeeConfigured|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathFeeConfigured|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathFeeConfigured|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathFeeConfigured|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathFeeConfigured|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeeConfigured
     */
    public function getAttributeName()
    {
        return 'FeeConfigured';
    }
}
