<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathUserInfo extends AbstractStructBase
{
    /**
     * The OriginationAuthority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OriginationAuthority;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Roles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfRoleOUAccessInfo
     */
    public $Roles;
    /**
     * Constructor method for UserInfo
     * @uses PathUserInfo::setOriginationAuthority()
     * @uses PathUserInfo::setUserID()
     * @uses PathUserInfo::setFirstName()
     * @uses PathUserInfo::setLastName()
     * @uses PathUserInfo::setRoles()
     * @param bool $originationAuthority
     * @param string $userID
     * @param string $firstName
     * @param string $lastName
     * @param \Path\pathArrayType\PathArrayOfRoleOUAccessInfo $roles
     */
    public function __construct($originationAuthority = null, $userID = null, $firstName = null, $lastName = null, \Path\pathArrayType\PathArrayOfRoleOUAccessInfo $roles = null)
    {
        $this
            ->setOriginationAuthority($originationAuthority)
            ->setUserID($userID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setRoles($roles);
    }
    /**
     * Get OriginationAuthority value
     * @return bool
     */
    public function getOriginationAuthority()
    {
        return $this->OriginationAuthority;
    }
    /**
     * Set OriginationAuthority value
     * @param bool $originationAuthority
     * @return \Path\pathStructType\PathUserInfo
     */
    public function setOriginationAuthority($originationAuthority = null)
    {
        // validation for constraint: boolean
        if (!is_null($originationAuthority) && !is_bool($originationAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($originationAuthority, true), gettype($originationAuthority)), __LINE__);
        }
        $this->OriginationAuthority = $originationAuthority;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \Path\pathStructType\PathUserInfo
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \Path\pathStructType\PathUserInfo
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \Path\pathStructType\PathUserInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Roles value
     * @return \Path\pathArrayType\PathArrayOfRoleOUAccessInfo|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \Path\pathArrayType\PathArrayOfRoleOUAccessInfo $roles
     * @return \Path\pathStructType\PathUserInfo
     */
    public function setRoles(\Path\pathArrayType\PathArrayOfRoleOUAccessInfo $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
}
