<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathStatusInfo extends AbstractStructBase
{
    /**
     * The StatusName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusName;
    /**
     * The statuscode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statuscode;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The substatuscode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $substatuscode;
    /**
     * The substatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $substatus;
    /**
     * Constructor method for StatusInfo
     * @uses PathStatusInfo::setStatusName()
     * @uses PathStatusInfo::setStatuscode()
     * @uses PathStatusInfo::setStatus()
     * @uses PathStatusInfo::setSubstatuscode()
     * @uses PathStatusInfo::setSubstatus()
     * @param string $statusName
     * @param string $statuscode
     * @param string $status
     * @param string $substatuscode
     * @param string $substatus
     */
    public function __construct($statusName = null, $statuscode = null, $status = null, $substatuscode = null, $substatus = null)
    {
        $this
            ->setStatusName($statusName)
            ->setStatuscode($statuscode)
            ->setStatus($status)
            ->setSubstatuscode($substatuscode)
            ->setSubstatus($substatus);
    }
    /**
     * Get StatusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->StatusName;
    }
    /**
     * Set StatusName value
     * @param string $statusName
     * @return \Path\pathStructType\PathStatusInfo
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusName, true), gettype($statusName)), __LINE__);
        }
        $this->StatusName = $statusName;
        return $this;
    }
    /**
     * Get statuscode value
     * @return string|null
     */
    public function getStatuscode()
    {
        return $this->statuscode;
    }
    /**
     * Set statuscode value
     * @param string $statuscode
     * @return \Path\pathStructType\PathStatusInfo
     */
    public function setStatuscode($statuscode = null)
    {
        // validation for constraint: string
        if (!is_null($statuscode) && !is_string($statuscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statuscode, true), gettype($statuscode)), __LINE__);
        }
        $this->statuscode = $statuscode;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Path\pathStructType\PathStatusInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get substatuscode value
     * @return string|null
     */
    public function getSubstatuscode()
    {
        return $this->substatuscode;
    }
    /**
     * Set substatuscode value
     * @param string $substatuscode
     * @return \Path\pathStructType\PathStatusInfo
     */
    public function setSubstatuscode($substatuscode = null)
    {
        // validation for constraint: string
        if (!is_null($substatuscode) && !is_string($substatuscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($substatuscode, true), gettype($substatuscode)), __LINE__);
        }
        $this->substatuscode = $substatuscode;
        return $this;
    }
    /**
     * Get substatus value
     * @return string|null
     */
    public function getSubstatus()
    {
        return $this->substatus;
    }
    /**
     * Set substatus value
     * @param string $substatus
     * @return \Path\pathStructType\PathStatusInfo
     */
    public function setSubstatus($substatus = null)
    {
        // validation for constraint: string
        if (!is_null($substatus) && !is_string($substatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($substatus, true), gettype($substatus)), __LINE__);
        }
        $this->substatus = $substatus;
        return $this;
    }
}
