<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultBUList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultBUList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The BUList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfBUInfo
     */
    public $BUList;
    /**
     * Constructor method for ResultBUList
     * @uses PathResultBUList::setStatus()
     * @uses PathResultBUList::setMessage()
     * @uses PathResultBUList::setBUList()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfBUInfo $bUList
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfBUInfo $bUList = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setBUList($bUList);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultBUList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultBUList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get BUList value
     * @return \Path\pathArrayType\PathArrayOfBUInfo|null
     */
    public function getBUList()
    {
        return $this->BUList;
    }
    /**
     * Set BUList value
     * @param \Path\pathArrayType\PathArrayOfBUInfo $bUList
     * @return \Path\pathStructType\PathResultBUList
     */
    public function setBUList(\Path\pathArrayType\PathArrayOfBUInfo $bUList = null)
    {
        $this->BUList = $bUList;
        return $this;
    }
}
