<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeData2 pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathFeeData2 extends AbstractStructBase
{
    /**
     * The LoanId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoanId;
    /**
     * The feeid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $feeid;
    /**
     * The AdditionalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AdditionalAmount;
    /**
     * The AnnualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AnnualAmount;
    /**
     * The APRIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $APRIndicator;
    /**
     * The BorrowerAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BorrowerAmt;
    /**
     * The BorrowerPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BorrowerPct;
    /**
     * The BorrowerPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BorrowerPOCIndicator;
    /**
     * The BorrowerSelectedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BorrowerSelectedIndicator;
    /**
     * The BrokerAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BrokerAmt;
    /**
     * The BrokerPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BrokerPct;
    /**
     * The BrokerPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BrokerPOCIndicator;
    /**
     * The CalculateNumberDaysIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CalculateNumberDaysIndicator;
    /**
     * The CorrespondentAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CorrespondentAmt;
    /**
     * The CorrespondentPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CorrespondentPct;
    /**
     * The CorrespondentPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CorrespondentPOCIndicator;
    /**
     * The CustomFeeIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomFeeIndicator;
    /**
     * The ExcludableIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludableIndicator;
    /**
     * The ExcludeFromMortgageDeedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludeFromMortgageDeedIndicator;
    /**
     * The FederalBonaFideIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FederalBonaFideIndicator;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FeeAmount;
    /**
     * The FHAAllowableIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FHAAllowableIndicator;
    /**
     * The FinancedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FinancedIndicator;
    /**
     * The GSEBonaFideIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GSEBonaFideIndicator;
    /**
     * The LenderAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LenderAmt;
    /**
     * The LenderPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LenderPct;
    /**
     * The LenderPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LenderPOCIndicator;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Percent;
    /**
     * The POCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $POCIndicator;
    /**
     * The QMIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $QMIndicator;
    /**
     * The SellerAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SellerAmt;
    /**
     * The SellerPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SellerPct;
    /**
     * The SellerPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SellerPOCIndicator;
    /**
     * The ShoppableIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShoppableIndicator;
    /**
     * The SplitByAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SplitByAmt;
    /**
     * The SplitByPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SplitByPct;
    /**
     * The StateBonaFideIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $StateBonaFideIndicator;
    /**
     * The ThirdPartyAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThirdPartyAmt;
    /**
     * The ThirdPartyPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThirdPartyPct;
    /**
     * The ThirdPartyPOCIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ThirdPartyPOCIndicator;
    /**
     * The EditDistributionDatesIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EditDistributionDatesIndicator;
    /**
     * The CalculateNumberDaysFromToIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CalculateNumberDaysFromToIndicator;
    /**
     * The RealEstateTaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RealEstateTaxID;
    /**
     * The SupplementalID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SupplementalID;
    /**
     * The OtherHousingExpenseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OtherHousingExpenseID;
    /**
     * The CompanyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyId;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The BasedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BasedOn;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The COCDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COCDate;
    /**
     * The COCReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COCReason;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contact;
    /**
     * The DailyInterestFromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyInterestFromDate;
    /**
     * The DailyInterestToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyInterestToDate;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeName;
    /**
     * The FeeSection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeSection;
    /**
     * The FeeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeType;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Frequency;
    /**
     * The MonthsCushion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthsCushion;
    /**
     * The NumberDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberDays;
    /**
     * The NumberMonths
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberMonths;
    /**
     * The PaidBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidBy;
    /**
     * The PaidTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidTo;
    /**
     * The PaidToCompany
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidToCompany;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The PrepaidType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrepaidType;
    /**
     * The ServiceProviderSourceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderSourceType;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The WithholdFromWire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WithholdFromWire;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The FeeTypeCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeTypeCD;
    /**
     * The FeeNameCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeNameCD;
    /**
     * The FeeSectionCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeSectionCD;
    /**
     * The BasedOnCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BasedOnCD;
    /**
     * The COCReasonCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COCReasonCD;
    /**
     * The FrequencyCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequencyCD;
    /**
     * The MonthsCushionCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthsCushionCD;
    /**
     * The PrepaidTypeCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrepaidTypeCD;
    /**
     * The ServiceProviderSourceTypeCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderSourceTypeCD;
    /**
     * The AdditionalDaysRequiringConsentCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalDaysRequiringConsentCD;
    /**
     * The AdditionalDaysRequiringConsent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalDaysRequiringConsent;
    /**
     * The ResponsibleParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponsibleParty;
    /**
     * The ResponsiblePartyCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponsiblePartyCD;
    /**
     * The GLNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GLNumber;
    /**
     * Constructor method for FeeData2
     * @uses PathFeeData2::setLoanId()
     * @uses PathFeeData2::setFeeid()
     * @uses PathFeeData2::setAdditionalAmount()
     * @uses PathFeeData2::setAnnualAmount()
     * @uses PathFeeData2::setAPRIndicator()
     * @uses PathFeeData2::setBorrowerAmt()
     * @uses PathFeeData2::setBorrowerPct()
     * @uses PathFeeData2::setBorrowerPOCIndicator()
     * @uses PathFeeData2::setBorrowerSelectedIndicator()
     * @uses PathFeeData2::setBrokerAmt()
     * @uses PathFeeData2::setBrokerPct()
     * @uses PathFeeData2::setBrokerPOCIndicator()
     * @uses PathFeeData2::setCalculateNumberDaysIndicator()
     * @uses PathFeeData2::setCorrespondentAmt()
     * @uses PathFeeData2::setCorrespondentPct()
     * @uses PathFeeData2::setCorrespondentPOCIndicator()
     * @uses PathFeeData2::setCustomFeeIndicator()
     * @uses PathFeeData2::setExcludableIndicator()
     * @uses PathFeeData2::setExcludeFromMortgageDeedIndicator()
     * @uses PathFeeData2::setFederalBonaFideIndicator()
     * @uses PathFeeData2::setFeeAmount()
     * @uses PathFeeData2::setFHAAllowableIndicator()
     * @uses PathFeeData2::setFinancedIndicator()
     * @uses PathFeeData2::setGSEBonaFideIndicator()
     * @uses PathFeeData2::setLenderAmt()
     * @uses PathFeeData2::setLenderPct()
     * @uses PathFeeData2::setLenderPOCIndicator()
     * @uses PathFeeData2::setPercent()
     * @uses PathFeeData2::setPOCIndicator()
     * @uses PathFeeData2::setQMIndicator()
     * @uses PathFeeData2::setSellerAmt()
     * @uses PathFeeData2::setSellerPct()
     * @uses PathFeeData2::setSellerPOCIndicator()
     * @uses PathFeeData2::setShoppableIndicator()
     * @uses PathFeeData2::setSplitByAmt()
     * @uses PathFeeData2::setSplitByPct()
     * @uses PathFeeData2::setStateBonaFideIndicator()
     * @uses PathFeeData2::setThirdPartyAmt()
     * @uses PathFeeData2::setThirdPartyPct()
     * @uses PathFeeData2::setThirdPartyPOCIndicator()
     * @uses PathFeeData2::setEditDistributionDatesIndicator()
     * @uses PathFeeData2::setCalculateNumberDaysFromToIndicator()
     * @uses PathFeeData2::setRealEstateTaxID()
     * @uses PathFeeData2::setSupplementalID()
     * @uses PathFeeData2::setOtherHousingExpenseID()
     * @uses PathFeeData2::setCompanyId()
     * @uses PathFeeData2::setAddress1()
     * @uses PathFeeData2::setAddress2()
     * @uses PathFeeData2::setBasedOn()
     * @uses PathFeeData2::setCity()
     * @uses PathFeeData2::setCOCDate()
     * @uses PathFeeData2::setCOCReason()
     * @uses PathFeeData2::setComments()
     * @uses PathFeeData2::setContact()
     * @uses PathFeeData2::setDailyInterestFromDate()
     * @uses PathFeeData2::setDailyInterestToDate()
     * @uses PathFeeData2::setEmail()
     * @uses PathFeeData2::setFeeName()
     * @uses PathFeeData2::setFeeSection()
     * @uses PathFeeData2::setFeeType()
     * @uses PathFeeData2::setFrequency()
     * @uses PathFeeData2::setMonthsCushion()
     * @uses PathFeeData2::setNumberDays()
     * @uses PathFeeData2::setNumberMonths()
     * @uses PathFeeData2::setPaidBy()
     * @uses PathFeeData2::setPaidTo()
     * @uses PathFeeData2::setPaidToCompany()
     * @uses PathFeeData2::setPhone()
     * @uses PathFeeData2::setPrepaidType()
     * @uses PathFeeData2::setServiceProviderSourceType()
     * @uses PathFeeData2::setState()
     * @uses PathFeeData2::setWithholdFromWire()
     * @uses PathFeeData2::setZip()
     * @uses PathFeeData2::setFeeTypeCD()
     * @uses PathFeeData2::setFeeNameCD()
     * @uses PathFeeData2::setFeeSectionCD()
     * @uses PathFeeData2::setBasedOnCD()
     * @uses PathFeeData2::setCOCReasonCD()
     * @uses PathFeeData2::setFrequencyCD()
     * @uses PathFeeData2::setMonthsCushionCD()
     * @uses PathFeeData2::setPrepaidTypeCD()
     * @uses PathFeeData2::setServiceProviderSourceTypeCD()
     * @uses PathFeeData2::setAdditionalDaysRequiringConsentCD()
     * @uses PathFeeData2::setAdditionalDaysRequiringConsent()
     * @uses PathFeeData2::setResponsibleParty()
     * @uses PathFeeData2::setResponsiblePartyCD()
     * @uses PathFeeData2::setGLNumber()
     * @param int $loanId
     * @param int $feeid
     * @param float $additionalAmount
     * @param float $annualAmount
     * @param bool $aPRIndicator
     * @param float $borrowerAmt
     * @param float $borrowerPct
     * @param bool $borrowerPOCIndicator
     * @param bool $borrowerSelectedIndicator
     * @param float $brokerAmt
     * @param float $brokerPct
     * @param bool $brokerPOCIndicator
     * @param bool $calculateNumberDaysIndicator
     * @param float $correspondentAmt
     * @param float $correspondentPct
     * @param bool $correspondentPOCIndicator
     * @param bool $customFeeIndicator
     * @param bool $excludableIndicator
     * @param bool $excludeFromMortgageDeedIndicator
     * @param bool $federalBonaFideIndicator
     * @param float $feeAmount
     * @param bool $fHAAllowableIndicator
     * @param bool $financedIndicator
     * @param bool $gSEBonaFideIndicator
     * @param float $lenderAmt
     * @param float $lenderPct
     * @param bool $lenderPOCIndicator
     * @param float $percent
     * @param bool $pOCIndicator
     * @param bool $qMIndicator
     * @param float $sellerAmt
     * @param float $sellerPct
     * @param bool $sellerPOCIndicator
     * @param bool $shoppableIndicator
     * @param bool $splitByAmt
     * @param bool $splitByPct
     * @param bool $stateBonaFideIndicator
     * @param float $thirdPartyAmt
     * @param float $thirdPartyPct
     * @param bool $thirdPartyPOCIndicator
     * @param bool $editDistributionDatesIndicator
     * @param bool $calculateNumberDaysFromToIndicator
     * @param int $realEstateTaxID
     * @param int $supplementalID
     * @param int $otherHousingExpenseID
     * @param string $companyId
     * @param string $address1
     * @param string $address2
     * @param string $basedOn
     * @param string $city
     * @param string $cOCDate
     * @param string $cOCReason
     * @param string $comments
     * @param string $contact
     * @param string $dailyInterestFromDate
     * @param string $dailyInterestToDate
     * @param string $email
     * @param string $feeName
     * @param string $feeSection
     * @param string $feeType
     * @param string $frequency
     * @param string $monthsCushion
     * @param string $numberDays
     * @param string $numberMonths
     * @param string $paidBy
     * @param string $paidTo
     * @param string $paidToCompany
     * @param string $phone
     * @param string $prepaidType
     * @param string $serviceProviderSourceType
     * @param string $state
     * @param string $withholdFromWire
     * @param string $zip
     * @param string $feeTypeCD
     * @param string $feeNameCD
     * @param string $feeSectionCD
     * @param string $basedOnCD
     * @param string $cOCReasonCD
     * @param string $frequencyCD
     * @param string $monthsCushionCD
     * @param string $prepaidTypeCD
     * @param string $serviceProviderSourceTypeCD
     * @param string $additionalDaysRequiringConsentCD
     * @param string $additionalDaysRequiringConsent
     * @param string $responsibleParty
     * @param string $responsiblePartyCD
     * @param string $gLNumber
     */
    public function __construct($loanId = null, $feeid = null, $additionalAmount = null, $annualAmount = null, $aPRIndicator = null, $borrowerAmt = null, $borrowerPct = null, $borrowerPOCIndicator = null, $borrowerSelectedIndicator = null, $brokerAmt = null, $brokerPct = null, $brokerPOCIndicator = null, $calculateNumberDaysIndicator = null, $correspondentAmt = null, $correspondentPct = null, $correspondentPOCIndicator = null, $customFeeIndicator = null, $excludableIndicator = null, $excludeFromMortgageDeedIndicator = null, $federalBonaFideIndicator = null, $feeAmount = null, $fHAAllowableIndicator = null, $financedIndicator = null, $gSEBonaFideIndicator = null, $lenderAmt = null, $lenderPct = null, $lenderPOCIndicator = null, $percent = null, $pOCIndicator = null, $qMIndicator = null, $sellerAmt = null, $sellerPct = null, $sellerPOCIndicator = null, $shoppableIndicator = null, $splitByAmt = null, $splitByPct = null, $stateBonaFideIndicator = null, $thirdPartyAmt = null, $thirdPartyPct = null, $thirdPartyPOCIndicator = null, $editDistributionDatesIndicator = null, $calculateNumberDaysFromToIndicator = null, $realEstateTaxID = null, $supplementalID = null, $otherHousingExpenseID = null, $companyId = null, $address1 = null, $address2 = null, $basedOn = null, $city = null, $cOCDate = null, $cOCReason = null, $comments = null, $contact = null, $dailyInterestFromDate = null, $dailyInterestToDate = null, $email = null, $feeName = null, $feeSection = null, $feeType = null, $frequency = null, $monthsCushion = null, $numberDays = null, $numberMonths = null, $paidBy = null, $paidTo = null, $paidToCompany = null, $phone = null, $prepaidType = null, $serviceProviderSourceType = null, $state = null, $withholdFromWire = null, $zip = null, $feeTypeCD = null, $feeNameCD = null, $feeSectionCD = null, $basedOnCD = null, $cOCReasonCD = null, $frequencyCD = null, $monthsCushionCD = null, $prepaidTypeCD = null, $serviceProviderSourceTypeCD = null, $additionalDaysRequiringConsentCD = null, $additionalDaysRequiringConsent = null, $responsibleParty = null, $responsiblePartyCD = null, $gLNumber = null)
    {
        $this
            ->setLoanId($loanId)
            ->setFeeid($feeid)
            ->setAdditionalAmount($additionalAmount)
            ->setAnnualAmount($annualAmount)
            ->setAPRIndicator($aPRIndicator)
            ->setBorrowerAmt($borrowerAmt)
            ->setBorrowerPct($borrowerPct)
            ->setBorrowerPOCIndicator($borrowerPOCIndicator)
            ->setBorrowerSelectedIndicator($borrowerSelectedIndicator)
            ->setBrokerAmt($brokerAmt)
            ->setBrokerPct($brokerPct)
            ->setBrokerPOCIndicator($brokerPOCIndicator)
            ->setCalculateNumberDaysIndicator($calculateNumberDaysIndicator)
            ->setCorrespondentAmt($correspondentAmt)
            ->setCorrespondentPct($correspondentPct)
            ->setCorrespondentPOCIndicator($correspondentPOCIndicator)
            ->setCustomFeeIndicator($customFeeIndicator)
            ->setExcludableIndicator($excludableIndicator)
            ->setExcludeFromMortgageDeedIndicator($excludeFromMortgageDeedIndicator)
            ->setFederalBonaFideIndicator($federalBonaFideIndicator)
            ->setFeeAmount($feeAmount)
            ->setFHAAllowableIndicator($fHAAllowableIndicator)
            ->setFinancedIndicator($financedIndicator)
            ->setGSEBonaFideIndicator($gSEBonaFideIndicator)
            ->setLenderAmt($lenderAmt)
            ->setLenderPct($lenderPct)
            ->setLenderPOCIndicator($lenderPOCIndicator)
            ->setPercent($percent)
            ->setPOCIndicator($pOCIndicator)
            ->setQMIndicator($qMIndicator)
            ->setSellerAmt($sellerAmt)
            ->setSellerPct($sellerPct)
            ->setSellerPOCIndicator($sellerPOCIndicator)
            ->setShoppableIndicator($shoppableIndicator)
            ->setSplitByAmt($splitByAmt)
            ->setSplitByPct($splitByPct)
            ->setStateBonaFideIndicator($stateBonaFideIndicator)
            ->setThirdPartyAmt($thirdPartyAmt)
            ->setThirdPartyPct($thirdPartyPct)
            ->setThirdPartyPOCIndicator($thirdPartyPOCIndicator)
            ->setEditDistributionDatesIndicator($editDistributionDatesIndicator)
            ->setCalculateNumberDaysFromToIndicator($calculateNumberDaysFromToIndicator)
            ->setRealEstateTaxID($realEstateTaxID)
            ->setSupplementalID($supplementalID)
            ->setOtherHousingExpenseID($otherHousingExpenseID)
            ->setCompanyId($companyId)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setBasedOn($basedOn)
            ->setCity($city)
            ->setCOCDate($cOCDate)
            ->setCOCReason($cOCReason)
            ->setComments($comments)
            ->setContact($contact)
            ->setDailyInterestFromDate($dailyInterestFromDate)
            ->setDailyInterestToDate($dailyInterestToDate)
            ->setEmail($email)
            ->setFeeName($feeName)
            ->setFeeSection($feeSection)
            ->setFeeType($feeType)
            ->setFrequency($frequency)
            ->setMonthsCushion($monthsCushion)
            ->setNumberDays($numberDays)
            ->setNumberMonths($numberMonths)
            ->setPaidBy($paidBy)
            ->setPaidTo($paidTo)
            ->setPaidToCompany($paidToCompany)
            ->setPhone($phone)
            ->setPrepaidType($prepaidType)
            ->setServiceProviderSourceType($serviceProviderSourceType)
            ->setState($state)
            ->setWithholdFromWire($withholdFromWire)
            ->setZip($zip)
            ->setFeeTypeCD($feeTypeCD)
            ->setFeeNameCD($feeNameCD)
            ->setFeeSectionCD($feeSectionCD)
            ->setBasedOnCD($basedOnCD)
            ->setCOCReasonCD($cOCReasonCD)
            ->setFrequencyCD($frequencyCD)
            ->setMonthsCushionCD($monthsCushionCD)
            ->setPrepaidTypeCD($prepaidTypeCD)
            ->setServiceProviderSourceTypeCD($serviceProviderSourceTypeCD)
            ->setAdditionalDaysRequiringConsentCD($additionalDaysRequiringConsentCD)
            ->setAdditionalDaysRequiringConsent($additionalDaysRequiringConsent)
            ->setResponsibleParty($responsibleParty)
            ->setResponsiblePartyCD($responsiblePartyCD)
            ->setGLNumber($gLNumber);
    }
    /**
     * Get LoanId value
     * @return int
     */
    public function getLoanId()
    {
        return $this->LoanId;
    }
    /**
     * Set LoanId value
     * @param int $loanId
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setLoanId($loanId = null)
    {
        // validation for constraint: int
        if (!is_null($loanId) && !(is_int($loanId) || ctype_digit($loanId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loanId, true), gettype($loanId)), __LINE__);
        }
        $this->LoanId = $loanId;
        return $this;
    }
    /**
     * Get feeid value
     * @return int
     */
    public function getFeeid()
    {
        return $this->feeid;
    }
    /**
     * Set feeid value
     * @param int $feeid
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeid($feeid = null)
    {
        // validation for constraint: int
        if (!is_null($feeid) && !(is_int($feeid) || ctype_digit($feeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feeid, true), gettype($feeid)), __LINE__);
        }
        $this->feeid = $feeid;
        return $this;
    }
    /**
     * Get AdditionalAmount value
     * @return float
     */
    public function getAdditionalAmount()
    {
        return $this->AdditionalAmount;
    }
    /**
     * Set AdditionalAmount value
     * @param float $additionalAmount
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAdditionalAmount($additionalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($additionalAmount) && !(is_float($additionalAmount) || is_numeric($additionalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalAmount, true), gettype($additionalAmount)), __LINE__);
        }
        $this->AdditionalAmount = $additionalAmount;
        return $this;
    }
    /**
     * Get AnnualAmount value
     * @return float
     */
    public function getAnnualAmount()
    {
        return $this->AnnualAmount;
    }
    /**
     * Set AnnualAmount value
     * @param float $annualAmount
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAnnualAmount($annualAmount = null)
    {
        // validation for constraint: float
        if (!is_null($annualAmount) && !(is_float($annualAmount) || is_numeric($annualAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualAmount, true), gettype($annualAmount)), __LINE__);
        }
        $this->AnnualAmount = $annualAmount;
        return $this;
    }
    /**
     * Get APRIndicator value
     * @return bool
     */
    public function getAPRIndicator()
    {
        return $this->APRIndicator;
    }
    /**
     * Set APRIndicator value
     * @param bool $aPRIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAPRIndicator($aPRIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($aPRIndicator) && !is_bool($aPRIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aPRIndicator, true), gettype($aPRIndicator)), __LINE__);
        }
        $this->APRIndicator = $aPRIndicator;
        return $this;
    }
    /**
     * Get BorrowerAmt value
     * @return float
     */
    public function getBorrowerAmt()
    {
        return $this->BorrowerAmt;
    }
    /**
     * Set BorrowerAmt value
     * @param float $borrowerAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBorrowerAmt($borrowerAmt = null)
    {
        // validation for constraint: float
        if (!is_null($borrowerAmt) && !(is_float($borrowerAmt) || is_numeric($borrowerAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($borrowerAmt, true), gettype($borrowerAmt)), __LINE__);
        }
        $this->BorrowerAmt = $borrowerAmt;
        return $this;
    }
    /**
     * Get BorrowerPct value
     * @return float
     */
    public function getBorrowerPct()
    {
        return $this->BorrowerPct;
    }
    /**
     * Set BorrowerPct value
     * @param float $borrowerPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBorrowerPct($borrowerPct = null)
    {
        // validation for constraint: float
        if (!is_null($borrowerPct) && !(is_float($borrowerPct) || is_numeric($borrowerPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($borrowerPct, true), gettype($borrowerPct)), __LINE__);
        }
        $this->BorrowerPct = $borrowerPct;
        return $this;
    }
    /**
     * Get BorrowerPOCIndicator value
     * @return bool
     */
    public function getBorrowerPOCIndicator()
    {
        return $this->BorrowerPOCIndicator;
    }
    /**
     * Set BorrowerPOCIndicator value
     * @param bool $borrowerPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBorrowerPOCIndicator($borrowerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($borrowerPOCIndicator) && !is_bool($borrowerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($borrowerPOCIndicator, true), gettype($borrowerPOCIndicator)), __LINE__);
        }
        $this->BorrowerPOCIndicator = $borrowerPOCIndicator;
        return $this;
    }
    /**
     * Get BorrowerSelectedIndicator value
     * @return bool
     */
    public function getBorrowerSelectedIndicator()
    {
        return $this->BorrowerSelectedIndicator;
    }
    /**
     * Set BorrowerSelectedIndicator value
     * @param bool $borrowerSelectedIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBorrowerSelectedIndicator($borrowerSelectedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($borrowerSelectedIndicator) && !is_bool($borrowerSelectedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($borrowerSelectedIndicator, true), gettype($borrowerSelectedIndicator)), __LINE__);
        }
        $this->BorrowerSelectedIndicator = $borrowerSelectedIndicator;
        return $this;
    }
    /**
     * Get BrokerAmt value
     * @return float
     */
    public function getBrokerAmt()
    {
        return $this->BrokerAmt;
    }
    /**
     * Set BrokerAmt value
     * @param float $brokerAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBrokerAmt($brokerAmt = null)
    {
        // validation for constraint: float
        if (!is_null($brokerAmt) && !(is_float($brokerAmt) || is_numeric($brokerAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($brokerAmt, true), gettype($brokerAmt)), __LINE__);
        }
        $this->BrokerAmt = $brokerAmt;
        return $this;
    }
    /**
     * Get BrokerPct value
     * @return float
     */
    public function getBrokerPct()
    {
        return $this->BrokerPct;
    }
    /**
     * Set BrokerPct value
     * @param float $brokerPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBrokerPct($brokerPct = null)
    {
        // validation for constraint: float
        if (!is_null($brokerPct) && !(is_float($brokerPct) || is_numeric($brokerPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($brokerPct, true), gettype($brokerPct)), __LINE__);
        }
        $this->BrokerPct = $brokerPct;
        return $this;
    }
    /**
     * Get BrokerPOCIndicator value
     * @return bool
     */
    public function getBrokerPOCIndicator()
    {
        return $this->BrokerPOCIndicator;
    }
    /**
     * Set BrokerPOCIndicator value
     * @param bool $brokerPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBrokerPOCIndicator($brokerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($brokerPOCIndicator) && !is_bool($brokerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($brokerPOCIndicator, true), gettype($brokerPOCIndicator)), __LINE__);
        }
        $this->BrokerPOCIndicator = $brokerPOCIndicator;
        return $this;
    }
    /**
     * Get CalculateNumberDaysIndicator value
     * @return bool
     */
    public function getCalculateNumberDaysIndicator()
    {
        return $this->CalculateNumberDaysIndicator;
    }
    /**
     * Set CalculateNumberDaysIndicator value
     * @param bool $calculateNumberDaysIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCalculateNumberDaysIndicator($calculateNumberDaysIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateNumberDaysIndicator) && !is_bool($calculateNumberDaysIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateNumberDaysIndicator, true), gettype($calculateNumberDaysIndicator)), __LINE__);
        }
        $this->CalculateNumberDaysIndicator = $calculateNumberDaysIndicator;
        return $this;
    }
    /**
     * Get CorrespondentAmt value
     * @return float
     */
    public function getCorrespondentAmt()
    {
        return $this->CorrespondentAmt;
    }
    /**
     * Set CorrespondentAmt value
     * @param float $correspondentAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCorrespondentAmt($correspondentAmt = null)
    {
        // validation for constraint: float
        if (!is_null($correspondentAmt) && !(is_float($correspondentAmt) || is_numeric($correspondentAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($correspondentAmt, true), gettype($correspondentAmt)), __LINE__);
        }
        $this->CorrespondentAmt = $correspondentAmt;
        return $this;
    }
    /**
     * Get CorrespondentPct value
     * @return float
     */
    public function getCorrespondentPct()
    {
        return $this->CorrespondentPct;
    }
    /**
     * Set CorrespondentPct value
     * @param float $correspondentPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCorrespondentPct($correspondentPct = null)
    {
        // validation for constraint: float
        if (!is_null($correspondentPct) && !(is_float($correspondentPct) || is_numeric($correspondentPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($correspondentPct, true), gettype($correspondentPct)), __LINE__);
        }
        $this->CorrespondentPct = $correspondentPct;
        return $this;
    }
    /**
     * Get CorrespondentPOCIndicator value
     * @return bool
     */
    public function getCorrespondentPOCIndicator()
    {
        return $this->CorrespondentPOCIndicator;
    }
    /**
     * Set CorrespondentPOCIndicator value
     * @param bool $correspondentPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCorrespondentPOCIndicator($correspondentPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($correspondentPOCIndicator) && !is_bool($correspondentPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($correspondentPOCIndicator, true), gettype($correspondentPOCIndicator)), __LINE__);
        }
        $this->CorrespondentPOCIndicator = $correspondentPOCIndicator;
        return $this;
    }
    /**
     * Get CustomFeeIndicator value
     * @return bool
     */
    public function getCustomFeeIndicator()
    {
        return $this->CustomFeeIndicator;
    }
    /**
     * Set CustomFeeIndicator value
     * @param bool $customFeeIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCustomFeeIndicator($customFeeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customFeeIndicator) && !is_bool($customFeeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customFeeIndicator, true), gettype($customFeeIndicator)), __LINE__);
        }
        $this->CustomFeeIndicator = $customFeeIndicator;
        return $this;
    }
    /**
     * Get ExcludableIndicator value
     * @return bool
     */
    public function getExcludableIndicator()
    {
        return $this->ExcludableIndicator;
    }
    /**
     * Set ExcludableIndicator value
     * @param bool $excludableIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setExcludableIndicator($excludableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludableIndicator) && !is_bool($excludableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludableIndicator, true), gettype($excludableIndicator)), __LINE__);
        }
        $this->ExcludableIndicator = $excludableIndicator;
        return $this;
    }
    /**
     * Get ExcludeFromMortgageDeedIndicator value
     * @return bool
     */
    public function getExcludeFromMortgageDeedIndicator()
    {
        return $this->ExcludeFromMortgageDeedIndicator;
    }
    /**
     * Set ExcludeFromMortgageDeedIndicator value
     * @param bool $excludeFromMortgageDeedIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setExcludeFromMortgageDeedIndicator($excludeFromMortgageDeedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromMortgageDeedIndicator) && !is_bool($excludeFromMortgageDeedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromMortgageDeedIndicator, true), gettype($excludeFromMortgageDeedIndicator)), __LINE__);
        }
        $this->ExcludeFromMortgageDeedIndicator = $excludeFromMortgageDeedIndicator;
        return $this;
    }
    /**
     * Get FederalBonaFideIndicator value
     * @return bool
     */
    public function getFederalBonaFideIndicator()
    {
        return $this->FederalBonaFideIndicator;
    }
    /**
     * Set FederalBonaFideIndicator value
     * @param bool $federalBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFederalBonaFideIndicator($federalBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($federalBonaFideIndicator) && !is_bool($federalBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($federalBonaFideIndicator, true), gettype($federalBonaFideIndicator)), __LINE__);
        }
        $this->FederalBonaFideIndicator = $federalBonaFideIndicator;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return float
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param float $feeAmount
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeAmount($feeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($feeAmount) && !(is_float($feeAmount) || is_numeric($feeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feeAmount, true), gettype($feeAmount)), __LINE__);
        }
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Get FHAAllowableIndicator value
     * @return bool
     */
    public function getFHAAllowableIndicator()
    {
        return $this->FHAAllowableIndicator;
    }
    /**
     * Set FHAAllowableIndicator value
     * @param bool $fHAAllowableIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFHAAllowableIndicator($fHAAllowableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fHAAllowableIndicator) && !is_bool($fHAAllowableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fHAAllowableIndicator, true), gettype($fHAAllowableIndicator)), __LINE__);
        }
        $this->FHAAllowableIndicator = $fHAAllowableIndicator;
        return $this;
    }
    /**
     * Get FinancedIndicator value
     * @return bool
     */
    public function getFinancedIndicator()
    {
        return $this->FinancedIndicator;
    }
    /**
     * Set FinancedIndicator value
     * @param bool $financedIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFinancedIndicator($financedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($financedIndicator) && !is_bool($financedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($financedIndicator, true), gettype($financedIndicator)), __LINE__);
        }
        $this->FinancedIndicator = $financedIndicator;
        return $this;
    }
    /**
     * Get GSEBonaFideIndicator value
     * @return bool
     */
    public function getGSEBonaFideIndicator()
    {
        return $this->GSEBonaFideIndicator;
    }
    /**
     * Set GSEBonaFideIndicator value
     * @param bool $gSEBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setGSEBonaFideIndicator($gSEBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($gSEBonaFideIndicator) && !is_bool($gSEBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gSEBonaFideIndicator, true), gettype($gSEBonaFideIndicator)), __LINE__);
        }
        $this->GSEBonaFideIndicator = $gSEBonaFideIndicator;
        return $this;
    }
    /**
     * Get LenderAmt value
     * @return float
     */
    public function getLenderAmt()
    {
        return $this->LenderAmt;
    }
    /**
     * Set LenderAmt value
     * @param float $lenderAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setLenderAmt($lenderAmt = null)
    {
        // validation for constraint: float
        if (!is_null($lenderAmt) && !(is_float($lenderAmt) || is_numeric($lenderAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lenderAmt, true), gettype($lenderAmt)), __LINE__);
        }
        $this->LenderAmt = $lenderAmt;
        return $this;
    }
    /**
     * Get LenderPct value
     * @return float
     */
    public function getLenderPct()
    {
        return $this->LenderPct;
    }
    /**
     * Set LenderPct value
     * @param float $lenderPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setLenderPct($lenderPct = null)
    {
        // validation for constraint: float
        if (!is_null($lenderPct) && !(is_float($lenderPct) || is_numeric($lenderPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lenderPct, true), gettype($lenderPct)), __LINE__);
        }
        $this->LenderPct = $lenderPct;
        return $this;
    }
    /**
     * Get LenderPOCIndicator value
     * @return bool
     */
    public function getLenderPOCIndicator()
    {
        return $this->LenderPOCIndicator;
    }
    /**
     * Set LenderPOCIndicator value
     * @param bool $lenderPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setLenderPOCIndicator($lenderPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($lenderPOCIndicator) && !is_bool($lenderPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lenderPOCIndicator, true), gettype($lenderPOCIndicator)), __LINE__);
        }
        $this->LenderPOCIndicator = $lenderPOCIndicator;
        return $this;
    }
    /**
     * Get Percent value
     * @return float
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get POCIndicator value
     * @return bool
     */
    public function getPOCIndicator()
    {
        return $this->POCIndicator;
    }
    /**
     * Set POCIndicator value
     * @param bool $pOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPOCIndicator($pOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($pOCIndicator) && !is_bool($pOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pOCIndicator, true), gettype($pOCIndicator)), __LINE__);
        }
        $this->POCIndicator = $pOCIndicator;
        return $this;
    }
    /**
     * Get QMIndicator value
     * @return bool
     */
    public function getQMIndicator()
    {
        return $this->QMIndicator;
    }
    /**
     * Set QMIndicator value
     * @param bool $qMIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setQMIndicator($qMIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($qMIndicator) && !is_bool($qMIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($qMIndicator, true), gettype($qMIndicator)), __LINE__);
        }
        $this->QMIndicator = $qMIndicator;
        return $this;
    }
    /**
     * Get SellerAmt value
     * @return float
     */
    public function getSellerAmt()
    {
        return $this->SellerAmt;
    }
    /**
     * Set SellerAmt value
     * @param float $sellerAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSellerAmt($sellerAmt = null)
    {
        // validation for constraint: float
        if (!is_null($sellerAmt) && !(is_float($sellerAmt) || is_numeric($sellerAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerAmt, true), gettype($sellerAmt)), __LINE__);
        }
        $this->SellerAmt = $sellerAmt;
        return $this;
    }
    /**
     * Get SellerPct value
     * @return float
     */
    public function getSellerPct()
    {
        return $this->SellerPct;
    }
    /**
     * Set SellerPct value
     * @param float $sellerPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSellerPct($sellerPct = null)
    {
        // validation for constraint: float
        if (!is_null($sellerPct) && !(is_float($sellerPct) || is_numeric($sellerPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerPct, true), gettype($sellerPct)), __LINE__);
        }
        $this->SellerPct = $sellerPct;
        return $this;
    }
    /**
     * Get SellerPOCIndicator value
     * @return bool
     */
    public function getSellerPOCIndicator()
    {
        return $this->SellerPOCIndicator;
    }
    /**
     * Set SellerPOCIndicator value
     * @param bool $sellerPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSellerPOCIndicator($sellerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellerPOCIndicator) && !is_bool($sellerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellerPOCIndicator, true), gettype($sellerPOCIndicator)), __LINE__);
        }
        $this->SellerPOCIndicator = $sellerPOCIndicator;
        return $this;
    }
    /**
     * Get ShoppableIndicator value
     * @return bool
     */
    public function getShoppableIndicator()
    {
        return $this->ShoppableIndicator;
    }
    /**
     * Set ShoppableIndicator value
     * @param bool $shoppableIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setShoppableIndicator($shoppableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($shoppableIndicator) && !is_bool($shoppableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shoppableIndicator, true), gettype($shoppableIndicator)), __LINE__);
        }
        $this->ShoppableIndicator = $shoppableIndicator;
        return $this;
    }
    /**
     * Get SplitByAmt value
     * @return bool
     */
    public function getSplitByAmt()
    {
        return $this->SplitByAmt;
    }
    /**
     * Set SplitByAmt value
     * @param bool $splitByAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSplitByAmt($splitByAmt = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitByAmt) && !is_bool($splitByAmt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($splitByAmt, true), gettype($splitByAmt)), __LINE__);
        }
        $this->SplitByAmt = $splitByAmt;
        return $this;
    }
    /**
     * Get SplitByPct value
     * @return bool
     */
    public function getSplitByPct()
    {
        return $this->SplitByPct;
    }
    /**
     * Set SplitByPct value
     * @param bool $splitByPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSplitByPct($splitByPct = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitByPct) && !is_bool($splitByPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($splitByPct, true), gettype($splitByPct)), __LINE__);
        }
        $this->SplitByPct = $splitByPct;
        return $this;
    }
    /**
     * Get StateBonaFideIndicator value
     * @return bool
     */
    public function getStateBonaFideIndicator()
    {
        return $this->StateBonaFideIndicator;
    }
    /**
     * Set StateBonaFideIndicator value
     * @param bool $stateBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setStateBonaFideIndicator($stateBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($stateBonaFideIndicator) && !is_bool($stateBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stateBonaFideIndicator, true), gettype($stateBonaFideIndicator)), __LINE__);
        }
        $this->StateBonaFideIndicator = $stateBonaFideIndicator;
        return $this;
    }
    /**
     * Get ThirdPartyAmt value
     * @return float
     */
    public function getThirdPartyAmt()
    {
        return $this->ThirdPartyAmt;
    }
    /**
     * Set ThirdPartyAmt value
     * @param float $thirdPartyAmt
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setThirdPartyAmt($thirdPartyAmt = null)
    {
        // validation for constraint: float
        if (!is_null($thirdPartyAmt) && !(is_float($thirdPartyAmt) || is_numeric($thirdPartyAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($thirdPartyAmt, true), gettype($thirdPartyAmt)), __LINE__);
        }
        $this->ThirdPartyAmt = $thirdPartyAmt;
        return $this;
    }
    /**
     * Get ThirdPartyPct value
     * @return float
     */
    public function getThirdPartyPct()
    {
        return $this->ThirdPartyPct;
    }
    /**
     * Set ThirdPartyPct value
     * @param float $thirdPartyPct
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setThirdPartyPct($thirdPartyPct = null)
    {
        // validation for constraint: float
        if (!is_null($thirdPartyPct) && !(is_float($thirdPartyPct) || is_numeric($thirdPartyPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($thirdPartyPct, true), gettype($thirdPartyPct)), __LINE__);
        }
        $this->ThirdPartyPct = $thirdPartyPct;
        return $this;
    }
    /**
     * Get ThirdPartyPOCIndicator value
     * @return bool
     */
    public function getThirdPartyPOCIndicator()
    {
        return $this->ThirdPartyPOCIndicator;
    }
    /**
     * Set ThirdPartyPOCIndicator value
     * @param bool $thirdPartyPOCIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setThirdPartyPOCIndicator($thirdPartyPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($thirdPartyPOCIndicator) && !is_bool($thirdPartyPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thirdPartyPOCIndicator, true), gettype($thirdPartyPOCIndicator)), __LINE__);
        }
        $this->ThirdPartyPOCIndicator = $thirdPartyPOCIndicator;
        return $this;
    }
    /**
     * Get EditDistributionDatesIndicator value
     * @return bool
     */
    public function getEditDistributionDatesIndicator()
    {
        return $this->EditDistributionDatesIndicator;
    }
    /**
     * Set EditDistributionDatesIndicator value
     * @param bool $editDistributionDatesIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setEditDistributionDatesIndicator($editDistributionDatesIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($editDistributionDatesIndicator) && !is_bool($editDistributionDatesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($editDistributionDatesIndicator, true), gettype($editDistributionDatesIndicator)), __LINE__);
        }
        $this->EditDistributionDatesIndicator = $editDistributionDatesIndicator;
        return $this;
    }
    /**
     * Get CalculateNumberDaysFromToIndicator value
     * @return bool
     */
    public function getCalculateNumberDaysFromToIndicator()
    {
        return $this->CalculateNumberDaysFromToIndicator;
    }
    /**
     * Set CalculateNumberDaysFromToIndicator value
     * @param bool $calculateNumberDaysFromToIndicator
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCalculateNumberDaysFromToIndicator($calculateNumberDaysFromToIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateNumberDaysFromToIndicator) && !is_bool($calculateNumberDaysFromToIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateNumberDaysFromToIndicator, true), gettype($calculateNumberDaysFromToIndicator)), __LINE__);
        }
        $this->CalculateNumberDaysFromToIndicator = $calculateNumberDaysFromToIndicator;
        return $this;
    }
    /**
     * Get RealEstateTaxID value
     * @return int
     */
    public function getRealEstateTaxID()
    {
        return $this->RealEstateTaxID;
    }
    /**
     * Set RealEstateTaxID value
     * @param int $realEstateTaxID
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setRealEstateTaxID($realEstateTaxID = null)
    {
        // validation for constraint: int
        if (!is_null($realEstateTaxID) && !(is_int($realEstateTaxID) || ctype_digit($realEstateTaxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($realEstateTaxID, true), gettype($realEstateTaxID)), __LINE__);
        }
        $this->RealEstateTaxID = $realEstateTaxID;
        return $this;
    }
    /**
     * Get SupplementalID value
     * @return int
     */
    public function getSupplementalID()
    {
        return $this->SupplementalID;
    }
    /**
     * Set SupplementalID value
     * @param int $supplementalID
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setSupplementalID($supplementalID = null)
    {
        // validation for constraint: int
        if (!is_null($supplementalID) && !(is_int($supplementalID) || ctype_digit($supplementalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplementalID, true), gettype($supplementalID)), __LINE__);
        }
        $this->SupplementalID = $supplementalID;
        return $this;
    }
    /**
     * Get OtherHousingExpenseID value
     * @return int
     */
    public function getOtherHousingExpenseID()
    {
        return $this->OtherHousingExpenseID;
    }
    /**
     * Set OtherHousingExpenseID value
     * @param int $otherHousingExpenseID
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setOtherHousingExpenseID($otherHousingExpenseID = null)
    {
        // validation for constraint: int
        if (!is_null($otherHousingExpenseID) && !(is_int($otherHousingExpenseID) || ctype_digit($otherHousingExpenseID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($otherHousingExpenseID, true), gettype($otherHousingExpenseID)), __LINE__);
        }
        $this->OtherHousingExpenseID = $otherHousingExpenseID;
        return $this;
    }
    /**
     * Get CompanyId value
     * @return string|null
     */
    public function getCompanyId()
    {
        return $this->CompanyId;
    }
    /**
     * Set CompanyId value
     * @param string $companyId
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCompanyId($companyId = null)
    {
        // validation for constraint: string
        if (!is_null($companyId) && !is_string($companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyId, true), gettype($companyId)), __LINE__);
        }
        $this->CompanyId = $companyId;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get BasedOn value
     * @return string|null
     */
    public function getBasedOn()
    {
        return $this->BasedOn;
    }
    /**
     * Set BasedOn value
     * @param string $basedOn
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBasedOn($basedOn = null)
    {
        // validation for constraint: string
        if (!is_null($basedOn) && !is_string($basedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basedOn, true), gettype($basedOn)), __LINE__);
        }
        $this->BasedOn = $basedOn;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get COCDate value
     * @return string|null
     */
    public function getCOCDate()
    {
        return $this->COCDate;
    }
    /**
     * Set COCDate value
     * @param string $cOCDate
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCOCDate($cOCDate = null)
    {
        // validation for constraint: string
        if (!is_null($cOCDate) && !is_string($cOCDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOCDate, true), gettype($cOCDate)), __LINE__);
        }
        $this->COCDate = $cOCDate;
        return $this;
    }
    /**
     * Get COCReason value
     * @return string|null
     */
    public function getCOCReason()
    {
        return $this->COCReason;
    }
    /**
     * Set COCReason value
     * @param string $cOCReason
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCOCReason($cOCReason = null)
    {
        // validation for constraint: string
        if (!is_null($cOCReason) && !is_string($cOCReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOCReason, true), gettype($cOCReason)), __LINE__);
        }
        $this->COCReason = $cOCReason;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param string $contact
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get DailyInterestFromDate value
     * @return string|null
     */
    public function getDailyInterestFromDate()
    {
        return $this->DailyInterestFromDate;
    }
    /**
     * Set DailyInterestFromDate value
     * @param string $dailyInterestFromDate
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setDailyInterestFromDate($dailyInterestFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($dailyInterestFromDate) && !is_string($dailyInterestFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dailyInterestFromDate, true), gettype($dailyInterestFromDate)), __LINE__);
        }
        $this->DailyInterestFromDate = $dailyInterestFromDate;
        return $this;
    }
    /**
     * Get DailyInterestToDate value
     * @return string|null
     */
    public function getDailyInterestToDate()
    {
        return $this->DailyInterestToDate;
    }
    /**
     * Set DailyInterestToDate value
     * @param string $dailyInterestToDate
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setDailyInterestToDate($dailyInterestToDate = null)
    {
        // validation for constraint: string
        if (!is_null($dailyInterestToDate) && !is_string($dailyInterestToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dailyInterestToDate, true), gettype($dailyInterestToDate)), __LINE__);
        }
        $this->DailyInterestToDate = $dailyInterestToDate;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FeeName value
     * @return string|null
     */
    public function getFeeName()
    {
        return $this->FeeName;
    }
    /**
     * Set FeeName value
     * @param string $feeName
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeName($feeName = null)
    {
        // validation for constraint: string
        if (!is_null($feeName) && !is_string($feeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeName, true), gettype($feeName)), __LINE__);
        }
        $this->FeeName = $feeName;
        return $this;
    }
    /**
     * Get FeeSection value
     * @return string|null
     */
    public function getFeeSection()
    {
        return $this->FeeSection;
    }
    /**
     * Set FeeSection value
     * @param string $feeSection
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeSection($feeSection = null)
    {
        // validation for constraint: string
        if (!is_null($feeSection) && !is_string($feeSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeSection, true), gettype($feeSection)), __LINE__);
        }
        $this->FeeSection = $feeSection;
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @param string $feeType
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeType, true), gettype($feeType)), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MonthsCushion value
     * @return string|null
     */
    public function getMonthsCushion()
    {
        return $this->MonthsCushion;
    }
    /**
     * Set MonthsCushion value
     * @param string $monthsCushion
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setMonthsCushion($monthsCushion = null)
    {
        // validation for constraint: string
        if (!is_null($monthsCushion) && !is_string($monthsCushion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthsCushion, true), gettype($monthsCushion)), __LINE__);
        }
        $this->MonthsCushion = $monthsCushion;
        return $this;
    }
    /**
     * Get NumberDays value
     * @return string|null
     */
    public function getNumberDays()
    {
        return $this->NumberDays;
    }
    /**
     * Set NumberDays value
     * @param string $numberDays
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setNumberDays($numberDays = null)
    {
        // validation for constraint: string
        if (!is_null($numberDays) && !is_string($numberDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberDays, true), gettype($numberDays)), __LINE__);
        }
        $this->NumberDays = $numberDays;
        return $this;
    }
    /**
     * Get NumberMonths value
     * @return string|null
     */
    public function getNumberMonths()
    {
        return $this->NumberMonths;
    }
    /**
     * Set NumberMonths value
     * @param string $numberMonths
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setNumberMonths($numberMonths = null)
    {
        // validation for constraint: string
        if (!is_null($numberMonths) && !is_string($numberMonths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberMonths, true), gettype($numberMonths)), __LINE__);
        }
        $this->NumberMonths = $numberMonths;
        return $this;
    }
    /**
     * Get PaidBy value
     * @return string|null
     */
    public function getPaidBy()
    {
        return $this->PaidBy;
    }
    /**
     * Set PaidBy value
     * @param string $paidBy
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPaidBy($paidBy = null)
    {
        // validation for constraint: string
        if (!is_null($paidBy) && !is_string($paidBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidBy, true), gettype($paidBy)), __LINE__);
        }
        $this->PaidBy = $paidBy;
        return $this;
    }
    /**
     * Get PaidTo value
     * @return string|null
     */
    public function getPaidTo()
    {
        return $this->PaidTo;
    }
    /**
     * Set PaidTo value
     * @param string $paidTo
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPaidTo($paidTo = null)
    {
        // validation for constraint: string
        if (!is_null($paidTo) && !is_string($paidTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidTo, true), gettype($paidTo)), __LINE__);
        }
        $this->PaidTo = $paidTo;
        return $this;
    }
    /**
     * Get PaidToCompany value
     * @return string|null
     */
    public function getPaidToCompany()
    {
        return $this->PaidToCompany;
    }
    /**
     * Set PaidToCompany value
     * @param string $paidToCompany
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPaidToCompany($paidToCompany = null)
    {
        // validation for constraint: string
        if (!is_null($paidToCompany) && !is_string($paidToCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidToCompany, true), gettype($paidToCompany)), __LINE__);
        }
        $this->PaidToCompany = $paidToCompany;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get PrepaidType value
     * @return string|null
     */
    public function getPrepaidType()
    {
        return $this->PrepaidType;
    }
    /**
     * Set PrepaidType value
     * @param string $prepaidType
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPrepaidType($prepaidType = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidType) && !is_string($prepaidType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaidType, true), gettype($prepaidType)), __LINE__);
        }
        $this->PrepaidType = $prepaidType;
        return $this;
    }
    /**
     * Get ServiceProviderSourceType value
     * @return string|null
     */
    public function getServiceProviderSourceType()
    {
        return $this->ServiceProviderSourceType;
    }
    /**
     * Set ServiceProviderSourceType value
     * @param string $serviceProviderSourceType
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setServiceProviderSourceType($serviceProviderSourceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderSourceType) && !is_string($serviceProviderSourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderSourceType, true), gettype($serviceProviderSourceType)), __LINE__);
        }
        $this->ServiceProviderSourceType = $serviceProviderSourceType;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get WithholdFromWire value
     * @return string|null
     */
    public function getWithholdFromWire()
    {
        return $this->WithholdFromWire;
    }
    /**
     * Set WithholdFromWire value
     * @param string $withholdFromWire
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setWithholdFromWire($withholdFromWire = null)
    {
        // validation for constraint: string
        if (!is_null($withholdFromWire) && !is_string($withholdFromWire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withholdFromWire, true), gettype($withholdFromWire)), __LINE__);
        }
        $this->WithholdFromWire = $withholdFromWire;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get FeeTypeCD value
     * @return string|null
     */
    public function getFeeTypeCD()
    {
        return $this->FeeTypeCD;
    }
    /**
     * Set FeeTypeCD value
     * @param string $feeTypeCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeTypeCD($feeTypeCD = null)
    {
        // validation for constraint: string
        if (!is_null($feeTypeCD) && !is_string($feeTypeCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeTypeCD, true), gettype($feeTypeCD)), __LINE__);
        }
        $this->FeeTypeCD = $feeTypeCD;
        return $this;
    }
    /**
     * Get FeeNameCD value
     * @return string|null
     */
    public function getFeeNameCD()
    {
        return $this->FeeNameCD;
    }
    /**
     * Set FeeNameCD value
     * @param string $feeNameCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeNameCD($feeNameCD = null)
    {
        // validation for constraint: string
        if (!is_null($feeNameCD) && !is_string($feeNameCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeNameCD, true), gettype($feeNameCD)), __LINE__);
        }
        $this->FeeNameCD = $feeNameCD;
        return $this;
    }
    /**
     * Get FeeSectionCD value
     * @return string|null
     */
    public function getFeeSectionCD()
    {
        return $this->FeeSectionCD;
    }
    /**
     * Set FeeSectionCD value
     * @param string $feeSectionCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFeeSectionCD($feeSectionCD = null)
    {
        // validation for constraint: string
        if (!is_null($feeSectionCD) && !is_string($feeSectionCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeSectionCD, true), gettype($feeSectionCD)), __LINE__);
        }
        $this->FeeSectionCD = $feeSectionCD;
        return $this;
    }
    /**
     * Get BasedOnCD value
     * @return string|null
     */
    public function getBasedOnCD()
    {
        return $this->BasedOnCD;
    }
    /**
     * Set BasedOnCD value
     * @param string $basedOnCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setBasedOnCD($basedOnCD = null)
    {
        // validation for constraint: string
        if (!is_null($basedOnCD) && !is_string($basedOnCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basedOnCD, true), gettype($basedOnCD)), __LINE__);
        }
        $this->BasedOnCD = $basedOnCD;
        return $this;
    }
    /**
     * Get COCReasonCD value
     * @return string|null
     */
    public function getCOCReasonCD()
    {
        return $this->COCReasonCD;
    }
    /**
     * Set COCReasonCD value
     * @param string $cOCReasonCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setCOCReasonCD($cOCReasonCD = null)
    {
        // validation for constraint: string
        if (!is_null($cOCReasonCD) && !is_string($cOCReasonCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOCReasonCD, true), gettype($cOCReasonCD)), __LINE__);
        }
        $this->COCReasonCD = $cOCReasonCD;
        return $this;
    }
    /**
     * Get FrequencyCD value
     * @return string|null
     */
    public function getFrequencyCD()
    {
        return $this->FrequencyCD;
    }
    /**
     * Set FrequencyCD value
     * @param string $frequencyCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setFrequencyCD($frequencyCD = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyCD) && !is_string($frequencyCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequencyCD, true), gettype($frequencyCD)), __LINE__);
        }
        $this->FrequencyCD = $frequencyCD;
        return $this;
    }
    /**
     * Get MonthsCushionCD value
     * @return string|null
     */
    public function getMonthsCushionCD()
    {
        return $this->MonthsCushionCD;
    }
    /**
     * Set MonthsCushionCD value
     * @param string $monthsCushionCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setMonthsCushionCD($monthsCushionCD = null)
    {
        // validation for constraint: string
        if (!is_null($monthsCushionCD) && !is_string($monthsCushionCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthsCushionCD, true), gettype($monthsCushionCD)), __LINE__);
        }
        $this->MonthsCushionCD = $monthsCushionCD;
        return $this;
    }
    /**
     * Get PrepaidTypeCD value
     * @return string|null
     */
    public function getPrepaidTypeCD()
    {
        return $this->PrepaidTypeCD;
    }
    /**
     * Set PrepaidTypeCD value
     * @param string $prepaidTypeCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setPrepaidTypeCD($prepaidTypeCD = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidTypeCD) && !is_string($prepaidTypeCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaidTypeCD, true), gettype($prepaidTypeCD)), __LINE__);
        }
        $this->PrepaidTypeCD = $prepaidTypeCD;
        return $this;
    }
    /**
     * Get ServiceProviderSourceTypeCD value
     * @return string|null
     */
    public function getServiceProviderSourceTypeCD()
    {
        return $this->ServiceProviderSourceTypeCD;
    }
    /**
     * Set ServiceProviderSourceTypeCD value
     * @param string $serviceProviderSourceTypeCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setServiceProviderSourceTypeCD($serviceProviderSourceTypeCD = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderSourceTypeCD) && !is_string($serviceProviderSourceTypeCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderSourceTypeCD, true), gettype($serviceProviderSourceTypeCD)), __LINE__);
        }
        $this->ServiceProviderSourceTypeCD = $serviceProviderSourceTypeCD;
        return $this;
    }
    /**
     * Get AdditionalDaysRequiringConsentCD value
     * @return string|null
     */
    public function getAdditionalDaysRequiringConsentCD()
    {
        return $this->AdditionalDaysRequiringConsentCD;
    }
    /**
     * Set AdditionalDaysRequiringConsentCD value
     * @param string $additionalDaysRequiringConsentCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAdditionalDaysRequiringConsentCD($additionalDaysRequiringConsentCD = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDaysRequiringConsentCD) && !is_string($additionalDaysRequiringConsentCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDaysRequiringConsentCD, true), gettype($additionalDaysRequiringConsentCD)), __LINE__);
        }
        $this->AdditionalDaysRequiringConsentCD = $additionalDaysRequiringConsentCD;
        return $this;
    }
    /**
     * Get AdditionalDaysRequiringConsent value
     * @return string|null
     */
    public function getAdditionalDaysRequiringConsent()
    {
        return $this->AdditionalDaysRequiringConsent;
    }
    /**
     * Set AdditionalDaysRequiringConsent value
     * @param string $additionalDaysRequiringConsent
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setAdditionalDaysRequiringConsent($additionalDaysRequiringConsent = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDaysRequiringConsent) && !is_string($additionalDaysRequiringConsent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDaysRequiringConsent, true), gettype($additionalDaysRequiringConsent)), __LINE__);
        }
        $this->AdditionalDaysRequiringConsent = $additionalDaysRequiringConsent;
        return $this;
    }
    /**
     * Get ResponsibleParty value
     * @return string|null
     */
    public function getResponsibleParty()
    {
        return $this->ResponsibleParty;
    }
    /**
     * Set ResponsibleParty value
     * @param string $responsibleParty
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setResponsibleParty($responsibleParty = null)
    {
        // validation for constraint: string
        if (!is_null($responsibleParty) && !is_string($responsibleParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsibleParty, true), gettype($responsibleParty)), __LINE__);
        }
        $this->ResponsibleParty = $responsibleParty;
        return $this;
    }
    /**
     * Get ResponsiblePartyCD value
     * @return string|null
     */
    public function getResponsiblePartyCD()
    {
        return $this->ResponsiblePartyCD;
    }
    /**
     * Set ResponsiblePartyCD value
     * @param string $responsiblePartyCD
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setResponsiblePartyCD($responsiblePartyCD = null)
    {
        // validation for constraint: string
        if (!is_null($responsiblePartyCD) && !is_string($responsiblePartyCD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsiblePartyCD, true), gettype($responsiblePartyCD)), __LINE__);
        }
        $this->ResponsiblePartyCD = $responsiblePartyCD;
        return $this;
    }
    /**
     * Get GLNumber value
     * @return string|null
     */
    public function getGLNumber()
    {
        return $this->GLNumber;
    }
    /**
     * Set GLNumber value
     * @param string $gLNumber
     * @return \Path\pathStructType\PathFeeData2
     */
    public function setGLNumber($gLNumber = null)
    {
        // validation for constraint: string
        if (!is_null($gLNumber) && !is_string($gLNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLNumber, true), gettype($gLNumber)), __LINE__);
        }
        $this->GLNumber = $gLNumber;
        return $this;
    }
}
