<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemplateList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathTemplateList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The TemplateInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfTemplateInfo
     */
    public $TemplateInfos;
    /**
     * Constructor method for TemplateList
     * @uses PathTemplateList::setStatus()
     * @uses PathTemplateList::setTemplateInfos()
     * @param int $status
     * @param \Path\pathArrayType\PathArrayOfTemplateInfo $templateInfos
     */
    public function __construct($status = null, \Path\pathArrayType\PathArrayOfTemplateInfo $templateInfos = null)
    {
        $this
            ->setStatus($status)
            ->setTemplateInfos($templateInfos);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathTemplateList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TemplateInfos value
     * @return \Path\pathArrayType\PathArrayOfTemplateInfo|null
     */
    public function getTemplateInfos()
    {
        return $this->TemplateInfos;
    }
    /**
     * Set TemplateInfos value
     * @param \Path\pathArrayType\PathArrayOfTemplateInfo $templateInfos
     * @return \Path\pathStructType\PathTemplateList
     */
    public function setTemplateInfos(\Path\pathArrayType\PathArrayOfTemplateInfo $templateInfos = null)
    {
        $this->TemplateInfos = $templateInfos;
        return $this;
    }
}
