<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemplateInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfTemplateInfo extends AbstractStructArrayBase
{
    /**
     * The TemplateInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathTemplateInfo[]
     */
    public $TemplateInfo;
    /**
     * Constructor method for ArrayOfTemplateInfo
     * @uses PathArrayOfTemplateInfo::setTemplateInfo()
     * @param \Path\pathStructType\PathTemplateInfo[] $templateInfo
     */
    public function __construct(array $templateInfo = array())
    {
        $this
            ->setTemplateInfo($templateInfo);
    }
    /**
     * Get TemplateInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathTemplateInfo[]|null
     */
    public function getTemplateInfo()
    {
        return isset($this->TemplateInfo) ? $this->TemplateInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTemplateInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemplateInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemplateInfoForArrayConstraintsFromSetTemplateInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTemplateInfoTemplateInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemplateInfoTemplateInfoItem instanceof \Path\pathStructType\PathTemplateInfo) {
                $invalidValues[] = is_object($arrayOfTemplateInfoTemplateInfoItem) ? get_class($arrayOfTemplateInfoTemplateInfoItem) : sprintf('%s(%s)', gettype($arrayOfTemplateInfoTemplateInfoItem), var_export($arrayOfTemplateInfoTemplateInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TemplateInfo property can only contain items of type \Path\pathStructType\PathTemplateInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TemplateInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathTemplateInfo[] $templateInfo
     * @return \Path\pathArrayType\PathArrayOfTemplateInfo
     */
    public function setTemplateInfo(array $templateInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($templateInfoArrayErrorMessage = self::validateTemplateInfoForArrayConstraintsFromSetTemplateInfo($templateInfo))) {
            throw new \InvalidArgumentException($templateInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($templateInfo) || (is_array($templateInfo) && empty($templateInfo))) {
            unset($this->TemplateInfo);
        } else {
            $this->TemplateInfo = $templateInfo;
        }
        return $this;
    }
    /**
     * Add item to TemplateInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathTemplateInfo $item
     * @return \Path\pathArrayType\PathArrayOfTemplateInfo
     */
    public function addToTemplateInfo(\Path\pathStructType\PathTemplateInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathTemplateInfo) {
            throw new \InvalidArgumentException(sprintf('The TemplateInfo property can only contain items of type \Path\pathStructType\PathTemplateInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TemplateInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathTemplateInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathTemplateInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathTemplateInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathTemplateInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathTemplateInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TemplateInfo
     */
    public function getAttributeName()
    {
        return 'TemplateInfo';
    }
}
