<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultStatusInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultStatusInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfStatusInfo
     */
    public $StatusInfo;
    /**
     * Constructor method for ResultStatusInfo
     * @uses PathResultStatusInfo::setStatus()
     * @uses PathResultStatusInfo::setMessage()
     * @uses PathResultStatusInfo::setStatusInfo()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfStatusInfo $statusInfo
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfStatusInfo $statusInfo = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultStatusInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultStatusInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get StatusInfo value
     * @return \Path\pathArrayType\PathArrayOfStatusInfo|null
     */
    public function getStatusInfo()
    {
        return $this->StatusInfo;
    }
    /**
     * Set StatusInfo value
     * @param \Path\pathArrayType\PathArrayOfStatusInfo $statusInfo
     * @return \Path\pathStructType\PathResultStatusInfo
     */
    public function setStatusInfo(\Path\pathArrayType\PathArrayOfStatusInfo $statusInfo = null)
    {
        $this->StatusInfo = $statusInfo;
        return $this;
    }
}
