<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultSSOAccessUrl pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultSSOAccessUrl extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AccessURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccessURL;
    /**
     * Constructor method for ResultSSOAccessUrl
     * @uses PathResultSSOAccessUrl::setStatus()
     * @uses PathResultSSOAccessUrl::setMessage()
     * @uses PathResultSSOAccessUrl::setAccessURL()
     * @param int $status
     * @param string $message
     * @param string $accessURL
     */
    public function __construct($status = null, $message = null, $accessURL = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setAccessURL($accessURL);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultSSOAccessUrl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultSSOAccessUrl
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AccessURL value
     * @return string|null
     */
    public function getAccessURL()
    {
        return $this->AccessURL;
    }
    /**
     * Set AccessURL value
     * @param string $accessURL
     * @return \Path\pathStructType\PathResultSSOAccessUrl
     */
    public function setAccessURL($accessURL = null)
    {
        // validation for constraint: string
        if (!is_null($accessURL) && !is_string($accessURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessURL, true), gettype($accessURL)), __LINE__);
        }
        $this->AccessURL = $accessURL;
        return $this;
    }
}
