<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultNewLoan pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultNewLoan extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The LoanNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoanNumber;
    /**
     * Constructor method for ResultNewLoan
     * @uses PathResultNewLoan::setStatus()
     * @uses PathResultNewLoan::setMessage()
     * @uses PathResultNewLoan::setLoanNumber()
     * @param int $status
     * @param string $message
     * @param string $loanNumber
     */
    public function __construct($status = null, $message = null, $loanNumber = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setLoanNumber($loanNumber);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultNewLoan
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultNewLoan
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get LoanNumber value
     * @return string|null
     */
    public function getLoanNumber()
    {
        return $this->LoanNumber;
    }
    /**
     * Set LoanNumber value
     * @param string $loanNumber
     * @return \Path\pathStructType\PathResultNewLoan
     */
    public function setLoanNumber($loanNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loanNumber) && !is_string($loanNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanNumber, true), gettype($loanNumber)), __LINE__);
        }
        $this->LoanNumber = $loanNumber;
        return $this;
    }
}
