<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSSOTokenedURL pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathGetSSOTokenedURL extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The userpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userpw;
    /**
     * The accountid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountid;
    /**
     * The oauthaccountaccesskey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $oauthaccountaccesskey;
    /**
     * Constructor method for GetSSOTokenedURL
     * @uses PathGetSSOTokenedURL::setUserid()
     * @uses PathGetSSOTokenedURL::setUserpw()
     * @uses PathGetSSOTokenedURL::setAccountid()
     * @uses PathGetSSOTokenedURL::setOauthaccountaccesskey()
     * @param string $userid
     * @param string $userpw
     * @param string $accountid
     * @param string $oauthaccountaccesskey
     */
    public function __construct($userid = null, $userpw = null, $accountid = null, $oauthaccountaccesskey = null)
    {
        $this
            ->setUserid($userid)
            ->setUserpw($userpw)
            ->setAccountid($accountid)
            ->setOauthaccountaccesskey($oauthaccountaccesskey);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \Path\pathStructType\PathGetSSOTokenedURL
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get userpw value
     * @return string|null
     */
    public function getUserpw()
    {
        return $this->userpw;
    }
    /**
     * Set userpw value
     * @param string $userpw
     * @return \Path\pathStructType\PathGetSSOTokenedURL
     */
    public function setUserpw($userpw = null)
    {
        // validation for constraint: string
        if (!is_null($userpw) && !is_string($userpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userpw, true), gettype($userpw)), __LINE__);
        }
        $this->userpw = $userpw;
        return $this;
    }
    /**
     * Get accountid value
     * @return string|null
     */
    public function getAccountid()
    {
        return $this->accountid;
    }
    /**
     * Set accountid value
     * @param string $accountid
     * @return \Path\pathStructType\PathGetSSOTokenedURL
     */
    public function setAccountid($accountid = null)
    {
        // validation for constraint: string
        if (!is_null($accountid) && !is_string($accountid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountid, true), gettype($accountid)), __LINE__);
        }
        $this->accountid = $accountid;
        return $this;
    }
    /**
     * Get oauthaccountaccesskey value
     * @return string|null
     */
    public function getOauthaccountaccesskey()
    {
        return $this->oauthaccountaccesskey;
    }
    /**
     * Set oauthaccountaccesskey value
     * @param string $oauthaccountaccesskey
     * @return \Path\pathStructType\PathGetSSOTokenedURL
     */
    public function setOauthaccountaccesskey($oauthaccountaccesskey = null)
    {
        // validation for constraint: string
        if (!is_null($oauthaccountaccesskey) && !is_string($oauthaccountaccesskey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oauthaccountaccesskey, true), gettype($oauthaccountaccesskey)), __LINE__);
        }
        $this->oauthaccountaccesskey = $oauthaccountaccesskey;
        return $this;
    }
}
