<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateLoanFeeData2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLoanFeeData2 $parameters
     * @return \Path\pathStructType\PathUpdateLoanFeeData2Response|bool
     */
    public function UpdateLoanFeeData2(\Path\pathStructType\PathUpdateLoanFeeData2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLoanFeeData2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLoanFeeData $parameters
     * @return \Path\pathStructType\PathUpdateLoanFeeDataResponse|bool
     */
    public function UpdateLoanFeeData(\Path\pathStructType\PathUpdateLoanFeeData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLockStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLockStatus $parameters
     * @return \Path\pathStructType\PathUpdateLockStatusResponse|bool
     */
    public function UpdateLockStatus(\Path\pathStructType\PathUpdateLockStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLockStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLockStatusWithNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLockStatusWithNote $parameters
     * @return \Path\pathStructType\PathUpdateLockStatusWithNoteResponse|bool
     */
    public function UpdateLockStatusWithNote(\Path\pathStructType\PathUpdateLockStatusWithNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLockStatusWithNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCompanyUserSign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateCompanyUserSign $parameters
     * @return \Path\pathStructType\PathUpdateCompanyUserSignResponse|bool
     */
    public function UpdateCompanyUserSign(\Path\pathStructType\PathUpdateCompanyUserSign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCompanyUserSign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathUpdateCompanyUserSignResponse|\Path\pathStructType\PathUpdateLoanFeeData2Response|\Path\pathStructType\PathUpdateLoanFeeDataResponse|\Path\pathStructType\PathUpdateLockStatusResponse|\Path\pathStructType\PathUpdateLockStatusWithNoteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
