<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathRoleInfo extends AbstractStructBase
{
    /**
     * The RoleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoleID;
    /**
     * The OriginationAuthority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OriginationAuthority;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * Constructor method for RoleInfo
     * @uses PathRoleInfo::setRoleID()
     * @uses PathRoleInfo::setOriginationAuthority()
     * @uses PathRoleInfo::setRoleName()
     * @param int $roleID
     * @param bool $originationAuthority
     * @param string $roleName
     */
    public function __construct($roleID = null, $originationAuthority = null, $roleName = null)
    {
        $this
            ->setRoleID($roleID)
            ->setOriginationAuthority($originationAuthority)
            ->setRoleName($roleName);
    }
    /**
     * Get RoleID value
     * @return int
     */
    public function getRoleID()
    {
        return $this->RoleID;
    }
    /**
     * Set RoleID value
     * @param int $roleID
     * @return \Path\pathStructType\PathRoleInfo
     */
    public function setRoleID($roleID = null)
    {
        // validation for constraint: int
        if (!is_null($roleID) && !(is_int($roleID) || ctype_digit($roleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleID, true), gettype($roleID)), __LINE__);
        }
        $this->RoleID = $roleID;
        return $this;
    }
    /**
     * Get OriginationAuthority value
     * @return bool
     */
    public function getOriginationAuthority()
    {
        return $this->OriginationAuthority;
    }
    /**
     * Set OriginationAuthority value
     * @param bool $originationAuthority
     * @return \Path\pathStructType\PathRoleInfo
     */
    public function setOriginationAuthority($originationAuthority = null)
    {
        // validation for constraint: boolean
        if (!is_null($originationAuthority) && !is_bool($originationAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($originationAuthority, true), gettype($originationAuthority)), __LINE__);
        }
        $this->OriginationAuthority = $originationAuthority;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \Path\pathStructType\PathRoleInfo
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleName, true), gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
}
