<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultUserInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultUserInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The UserInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathStructType\PathUserInfo
     */
    public $UserInfo;
    /**
     * Constructor method for ResultUserInfo
     * @uses PathResultUserInfo::setStatus()
     * @uses PathResultUserInfo::setMessage()
     * @uses PathResultUserInfo::setUserInfo()
     * @param int $status
     * @param string $message
     * @param \Path\pathStructType\PathUserInfo $userInfo
     */
    public function __construct($status = null, $message = null, \Path\pathStructType\PathUserInfo $userInfo = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setUserInfo($userInfo);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultUserInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultUserInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get UserInfo value
     * @return \Path\pathStructType\PathUserInfo|null
     */
    public function getUserInfo()
    {
        return $this->UserInfo;
    }
    /**
     * Set UserInfo value
     * @param \Path\pathStructType\PathUserInfo $userInfo
     * @return \Path\pathStructType\PathResultUserInfo
     */
    public function setUserInfo(\Path\pathStructType\PathUserInfo $userInfo = null)
    {
        $this->UserInfo = $userInfo;
        return $this;
    }
}
