<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultToken extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AccountAccessToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountAccessToken;
    /**
     * Constructor method for ResultToken
     * @uses PathResultToken::setStatus()
     * @uses PathResultToken::setMessage()
     * @uses PathResultToken::setAccountAccessToken()
     * @param int $status
     * @param string $message
     * @param string $accountAccessToken
     */
    public function __construct($status = null, $message = null, $accountAccessToken = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setAccountAccessToken($accountAccessToken);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultToken
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultToken
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AccountAccessToken value
     * @return string|null
     */
    public function getAccountAccessToken()
    {
        return $this->AccountAccessToken;
    }
    /**
     * Set AccountAccessToken value
     * @param string $accountAccessToken
     * @return \Path\pathStructType\PathResultToken
     */
    public function setAccountAccessToken($accountAccessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accountAccessToken) && !is_string($accountAccessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAccessToken, true), gettype($accountAccessToken)), __LINE__);
        }
        $this->AccountAccessToken = $accountAccessToken;
        return $this;
    }
}
