<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcctPostReportRequest pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathAcctPostReportRequest extends AbstractStructBase
{
    /**
     * The roleid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $roleid;
    /**
     * The templateid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $templateid;
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The accountaccesstoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountaccesstoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The loannumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $loannumbers;
    /**
     * Constructor method for AcctPostReportRequest
     * @uses PathAcctPostReportRequest::setRoleid()
     * @uses PathAcctPostReportRequest::setTemplateid()
     * @uses PathAcctPostReportRequest::setVendorid()
     * @uses PathAcctPostReportRequest::setAccountaccesstoken()
     * @uses PathAcctPostReportRequest::setVendorpw()
     * @uses PathAcctPostReportRequest::setLoannumbers()
     * @param int $roleid
     * @param int $templateid
     * @param string $vendorid
     * @param string $accountaccesstoken
     * @param string $vendorpw
     * @param \Path\pathArrayType\PathArrayOfString $loannumbers
     */
    public function __construct($roleid = null, $templateid = null, $vendorid = null, $accountaccesstoken = null, $vendorpw = null, \Path\pathArrayType\PathArrayOfString $loannumbers = null)
    {
        $this
            ->setRoleid($roleid)
            ->setTemplateid($templateid)
            ->setVendorid($vendorid)
            ->setAccountaccesstoken($accountaccesstoken)
            ->setVendorpw($vendorpw)
            ->setLoannumbers($loannumbers);
    }
    /**
     * Get roleid value
     * @return int
     */
    public function getRoleid()
    {
        return $this->roleid;
    }
    /**
     * Set roleid value
     * @param int $roleid
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setRoleid($roleid = null)
    {
        // validation for constraint: int
        if (!is_null($roleid) && !(is_int($roleid) || ctype_digit($roleid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleid, true), gettype($roleid)), __LINE__);
        }
        $this->roleid = $roleid;
        return $this;
    }
    /**
     * Get templateid value
     * @return int
     */
    public function getTemplateid()
    {
        return $this->templateid;
    }
    /**
     * Set templateid value
     * @param int $templateid
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setTemplateid($templateid = null)
    {
        // validation for constraint: int
        if (!is_null($templateid) && !(is_int($templateid) || ctype_digit($templateid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateid, true), gettype($templateid)), __LINE__);
        }
        $this->templateid = $templateid;
        return $this;
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get accountaccesstoken value
     * @return string|null
     */
    public function getAccountaccesstoken()
    {
        return $this->accountaccesstoken;
    }
    /**
     * Set accountaccesstoken value
     * @param string $accountaccesstoken
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setAccountaccesstoken($accountaccesstoken = null)
    {
        // validation for constraint: string
        if (!is_null($accountaccesstoken) && !is_string($accountaccesstoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountaccesstoken, true), gettype($accountaccesstoken)), __LINE__);
        }
        $this->accountaccesstoken = $accountaccesstoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get loannumbers value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getLoannumbers()
    {
        return $this->loannumbers;
    }
    /**
     * Set loannumbers value
     * @param \Path\pathArrayType\PathArrayOfString $loannumbers
     * @return \Path\pathStructType\PathAcctPostReportRequest
     */
    public function setLoannumbers(\Path\pathArrayType\PathArrayOfString $loannumbers = null)
    {
        $this->loannumbers = $loannumbers;
        return $this;
    }
}
