<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateNewLoanWithXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathCreateNewLoanWithXML $parameters
     * @return \Path\pathStructType\PathCreateNewLoanWithXMLResponse|bool
     */
    public function CreateNewLoanWithXML(\Path\pathStructType\PathCreateNewLoanWithXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateNewLoanWithXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNewLoan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathCreateNewLoan $parameters
     * @return \Path\pathStructType\PathCreateNewLoanResponse|bool
     */
    public function CreateNewLoan(\Path\pathStructType\PathCreateNewLoan $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateNewLoan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathCreateNewLoanResponse|\Path\pathStructType\PathCreateNewLoanWithXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
