<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatusInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfStatusInfo extends AbstractStructArrayBase
{
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathStatusInfo[]
     */
    public $StatusInfo;
    /**
     * Constructor method for ArrayOfStatusInfo
     * @uses PathArrayOfStatusInfo::setStatusInfo()
     * @param \Path\pathStructType\PathStatusInfo[] $statusInfo
     */
    public function __construct(array $statusInfo = array())
    {
        $this
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get StatusInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathStatusInfo[]|null
     */
    public function getStatusInfo()
    {
        return isset($this->StatusInfo) ? $this->StatusInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusInfoForArrayConstraintsFromSetStatusInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStatusInfoStatusInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfStatusInfoStatusInfoItem instanceof \Path\pathStructType\PathStatusInfo) {
                $invalidValues[] = is_object($arrayOfStatusInfoStatusInfoItem) ? get_class($arrayOfStatusInfoStatusInfoItem) : sprintf('%s(%s)', gettype($arrayOfStatusInfoStatusInfoItem), var_export($arrayOfStatusInfoStatusInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatusInfo property can only contain items of type \Path\pathStructType\PathStatusInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathStatusInfo[] $statusInfo
     * @return \Path\pathArrayType\PathArrayOfStatusInfo
     */
    public function setStatusInfo(array $statusInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($statusInfoArrayErrorMessage = self::validateStatusInfoForArrayConstraintsFromSetStatusInfo($statusInfo))) {
            throw new \InvalidArgumentException($statusInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($statusInfo) || (is_array($statusInfo) && empty($statusInfo))) {
            unset($this->StatusInfo);
        } else {
            $this->StatusInfo = $statusInfo;
        }
        return $this;
    }
    /**
     * Add item to StatusInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathStatusInfo $item
     * @return \Path\pathArrayType\PathArrayOfStatusInfo
     */
    public function addToStatusInfo(\Path\pathStructType\PathStatusInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathStatusInfo) {
            throw new \InvalidArgumentException(sprintf('The StatusInfo property can only contain items of type \Path\pathStructType\PathStatusInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatusInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathStatusInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathStatusInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathStatusInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathStatusInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathStatusInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StatusInfo
     */
    public function getAttributeName()
    {
        return 'StatusInfo';
    }
}
