<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOUInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfOUInfo extends AbstractStructArrayBase
{
    /**
     * The OUInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathOUInfo[]
     */
    public $OUInfo;
    /**
     * Constructor method for ArrayOfOUInfo
     * @uses PathArrayOfOUInfo::setOUInfo()
     * @param \Path\pathStructType\PathOUInfo[] $oUInfo
     */
    public function __construct(array $oUInfo = array())
    {
        $this
            ->setOUInfo($oUInfo);
    }
    /**
     * Get OUInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathOUInfo[]|null
     */
    public function getOUInfo()
    {
        return isset($this->OUInfo) ? $this->OUInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOUInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOUInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOUInfoForArrayConstraintsFromSetOUInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOUInfoOUInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfOUInfoOUInfoItem instanceof \Path\pathStructType\PathOUInfo) {
                $invalidValues[] = is_object($arrayOfOUInfoOUInfoItem) ? get_class($arrayOfOUInfoOUInfoItem) : sprintf('%s(%s)', gettype($arrayOfOUInfoOUInfoItem), var_export($arrayOfOUInfoOUInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OUInfo property can only contain items of type \Path\pathStructType\PathOUInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OUInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathOUInfo[] $oUInfo
     * @return \Path\pathArrayType\PathArrayOfOUInfo
     */
    public function setOUInfo(array $oUInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($oUInfoArrayErrorMessage = self::validateOUInfoForArrayConstraintsFromSetOUInfo($oUInfo))) {
            throw new \InvalidArgumentException($oUInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($oUInfo) || (is_array($oUInfo) && empty($oUInfo))) {
            unset($this->OUInfo);
        } else {
            $this->OUInfo = $oUInfo;
        }
        return $this;
    }
    /**
     * Add item to OUInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathOUInfo $item
     * @return \Path\pathArrayType\PathArrayOfOUInfo
     */
    public function addToOUInfo(\Path\pathStructType\PathOUInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathOUInfo) {
            throw new \InvalidArgumentException(sprintf('The OUInfo property can only contain items of type \Path\pathStructType\PathOUInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OUInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathOUInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathOUInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathOUInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathOUInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathOUInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OUInfo
     */
    public function getAttributeName()
    {
        return 'OUInfo';
    }
}
