<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfDocumentInfo extends AbstractStructArrayBase
{
    /**
     * The DocumentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathDocumentInfo[]
     */
    public $DocumentInfo;
    /**
     * Constructor method for ArrayOfDocumentInfo
     * @uses PathArrayOfDocumentInfo::setDocumentInfo()
     * @param \Path\pathStructType\PathDocumentInfo[] $documentInfo
     */
    public function __construct(array $documentInfo = array())
    {
        $this
            ->setDocumentInfo($documentInfo);
    }
    /**
     * Get DocumentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathDocumentInfo[]|null
     */
    public function getDocumentInfo()
    {
        return isset($this->DocumentInfo) ? $this->DocumentInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentInfoForArrayConstraintsFromSetDocumentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentInfoDocumentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentInfoDocumentInfoItem instanceof \Path\pathStructType\PathDocumentInfo) {
                $invalidValues[] = is_object($arrayOfDocumentInfoDocumentInfoItem) ? get_class($arrayOfDocumentInfoDocumentInfoItem) : sprintf('%s(%s)', gettype($arrayOfDocumentInfoDocumentInfoItem), var_export($arrayOfDocumentInfoDocumentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentInfo property can only contain items of type \Path\pathStructType\PathDocumentInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathDocumentInfo[] $documentInfo
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public function setDocumentInfo(array $documentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($documentInfoArrayErrorMessage = self::validateDocumentInfoForArrayConstraintsFromSetDocumentInfo($documentInfo))) {
            throw new \InvalidArgumentException($documentInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($documentInfo) || (is_array($documentInfo) && empty($documentInfo))) {
            unset($this->DocumentInfo);
        } else {
            $this->DocumentInfo = $documentInfo;
        }
        return $this;
    }
    /**
     * Add item to DocumentInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathDocumentInfo $item
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public function addToDocumentInfo(\Path\pathStructType\PathDocumentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathDocumentInfo) {
            throw new \InvalidArgumentException(sprintf('The DocumentInfo property can only contain items of type \Path\pathStructType\PathDocumentInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentInfo
     */
    public function getAttributeName()
    {
        return 'DocumentInfo';
    }
}
