<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBUInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfBUInfo extends AbstractStructArrayBase
{
    /**
     * The BUInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathBUInfo[]
     */
    public $BUInfo;
    /**
     * Constructor method for ArrayOfBUInfo
     * @uses PathArrayOfBUInfo::setBUInfo()
     * @param \Path\pathStructType\PathBUInfo[] $bUInfo
     */
    public function __construct(array $bUInfo = array())
    {
        $this
            ->setBUInfo($bUInfo);
    }
    /**
     * Get BUInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathBUInfo[]|null
     */
    public function getBUInfo()
    {
        return isset($this->BUInfo) ? $this->BUInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBUInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBUInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBUInfoForArrayConstraintsFromSetBUInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBUInfoBUInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBUInfoBUInfoItem instanceof \Path\pathStructType\PathBUInfo) {
                $invalidValues[] = is_object($arrayOfBUInfoBUInfoItem) ? get_class($arrayOfBUInfoBUInfoItem) : sprintf('%s(%s)', gettype($arrayOfBUInfoBUInfoItem), var_export($arrayOfBUInfoBUInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BUInfo property can only contain items of type \Path\pathStructType\PathBUInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BUInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathBUInfo[] $bUInfo
     * @return \Path\pathArrayType\PathArrayOfBUInfo
     */
    public function setBUInfo(array $bUInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($bUInfoArrayErrorMessage = self::validateBUInfoForArrayConstraintsFromSetBUInfo($bUInfo))) {
            throw new \InvalidArgumentException($bUInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($bUInfo) || (is_array($bUInfo) && empty($bUInfo))) {
            unset($this->BUInfo);
        } else {
            $this->BUInfo = $bUInfo;
        }
        return $this;
    }
    /**
     * Add item to BUInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathBUInfo $item
     * @return \Path\pathArrayType\PathArrayOfBUInfo
     */
    public function addToBUInfo(\Path\pathStructType\PathBUInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathBUInfo) {
            throw new \InvalidArgumentException(sprintf('The BUInfo property can only contain items of type \Path\pathStructType\PathBUInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BUInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathBUInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathBUInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathBUInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathBUInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathBUInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BUInfo
     */
    public function getAttributeName()
    {
        return 'BUInfo';
    }
}
