<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLoanFeeData pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathUpdateLoanFeeData extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The feedata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathStructType\PathFeeData
     */
    public $feedata;
    /**
     * Constructor method for UpdateLoanFeeData
     * @uses PathUpdateLoanFeeData::setVendorid()
     * @uses PathUpdateLoanFeeData::setApitoken()
     * @uses PathUpdateLoanFeeData::setVendorpw()
     * @uses PathUpdateLoanFeeData::setFeedata()
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     * @param \Path\pathStructType\PathFeeData $feedata
     */
    public function __construct($vendorid = null, $apitoken = null, $vendorpw = null, \Path\pathStructType\PathFeeData $feedata = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw)
            ->setFeedata($feedata);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathUpdateLoanFeeData
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathUpdateLoanFeeData
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apitoken, true), gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathUpdateLoanFeeData
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get feedata value
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function getFeedata()
    {
        return $this->feedata;
    }
    /**
     * Set feedata value
     * @param \Path\pathStructType\PathFeeData $feedata
     * @return \Path\pathStructType\PathUpdateLoanFeeData
     */
    public function setFeedata(\Path\pathStructType\PathFeeData $feedata = null)
    {
        $this->feedata = $feedata;
        return $this;
    }
}
