<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse StructType
 * @subpackage Structs
 */
class READResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int
     */
    public $st_flag;
    /**
     * The st_title
     * @var string
     */
    public $st_title;
    /**
     * The vg_code
     * @var string
     */
    public $vg_code;
    /**
     * The return_vg
     * @var string
     */
    public $return_vg;
    /**
     * The epitagh_vg
     * @var string
     */
    public $epitagh_vg;
    /**
     * The vg_child
     * Meta information extracted from the WSDL
     * - maxOccurs: 35
     * - minOccurs: 0
     * @var string[]
     */
    public $vg_child;
    /**
     * Constructor method for READResponse
     * @uses READResponse::setSt_flag()
     * @uses READResponse::setSt_title()
     * @uses READResponse::setVg_code()
     * @uses READResponse::setReturn_vg()
     * @uses READResponse::setEpitagh_vg()
     * @uses READResponse::setVg_child()
     * @param int $st_flag
     * @param string $st_title
     * @param string $vg_code
     * @param string $return_vg
     * @param string $epitagh_vg
     * @param string[] $vg_child
     */
    public function __construct($st_flag = null, $st_title = null, $vg_code = null, $return_vg = null, $epitagh_vg = null, array $vg_child = array())
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setVg_code($vg_code)
            ->setReturn_vg($return_vg)
            ->setEpitagh_vg($epitagh_vg)
            ->setVg_child($vg_child);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag()
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \StructType\READResponse
     */
    public function setSt_flag($st_flag = null)
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title()
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \StructType\READResponse
     */
    public function setSt_title($st_title = null)
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        return $this;
    }
    /**
     * Get vg_code value
     * @return string|null
     */
    public function getVg_code()
    {
        return $this->vg_code;
    }
    /**
     * Set vg_code value
     * @param string $vg_code
     * @return \StructType\READResponse
     */
    public function setVg_code($vg_code = null)
    {
        // validation for constraint: string
        if (!is_null($vg_code) && !is_string($vg_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vg_code, true), gettype($vg_code)), __LINE__);
        }
        $this->vg_code = $vg_code;
        return $this;
    }
    /**
     * Get return_vg value
     * @return string|null
     */
    public function getReturn_vg()
    {
        return $this->return_vg;
    }
    /**
     * Set return_vg value
     * @param string $return_vg
     * @return \StructType\READResponse
     */
    public function setReturn_vg($return_vg = null)
    {
        // validation for constraint: string
        if (!is_null($return_vg) && !is_string($return_vg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_vg, true), gettype($return_vg)), __LINE__);
        }
        $this->return_vg = $return_vg;
        return $this;
    }
    /**
     * Get epitagh_vg value
     * @return string|null
     */
    public function getEpitagh_vg()
    {
        return $this->epitagh_vg;
    }
    /**
     * Set epitagh_vg value
     * @param string $epitagh_vg
     * @return \StructType\READResponse
     */
    public function setEpitagh_vg($epitagh_vg = null)
    {
        // validation for constraint: string
        if (!is_null($epitagh_vg) && !is_string($epitagh_vg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($epitagh_vg, true), gettype($epitagh_vg)), __LINE__);
        }
        $this->epitagh_vg = $epitagh_vg;
        return $this;
    }
    /**
     * Get vg_child value
     * @return string[]|null
     */
    public function getVg_child()
    {
        return $this->vg_child;
    }
    /**
     * This method is responsible for validating the values passed to the setVg_child method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVg_child method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVg_childForArrayConstraintsFromSetVg_child(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rEADResponseVg_childItem) {
            // validation for constraint: itemType
            if (!is_string($rEADResponseVg_childItem)) {
                $invalidValues[] = is_object($rEADResponseVg_childItem) ? get_class($rEADResponseVg_childItem) : sprintf('%s(%s)', gettype($rEADResponseVg_childItem), var_export($rEADResponseVg_childItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vg_child property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vg_child value
     * @throws \InvalidArgumentException
     * @param string[] $vg_child
     * @return \StructType\READResponse
     */
    public function setVg_child(array $vg_child = array())
    {
        // validation for constraint: array
        if ('' !== ($vg_childArrayErrorMessage = self::validateVg_childForArrayConstraintsFromSetVg_child($vg_child))) {
            throw new \InvalidArgumentException($vg_childArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(35)
        if (is_array($vg_child) && count($vg_child) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 35', count($vg_child)), __LINE__);
        }
        $this->vg_child = $vg_child;
        return $this;
    }
    /**
     * Add item to vg_child value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\READResponse
     */
    public function addToVg_child($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The vg_child property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(35)
        if (is_array($this->vg_child) && count($this->vg_child) >= 35) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 35', count($this->vg_child)), __LINE__);
        }
        $this->vg_child[] = $item;
        return $this;
    }
}
