<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/wsdl/5',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/wsdl/5',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \ServiceType\Hello($options);
$hello->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld() !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for GetProducts operation/method
 */
if ($get->GetProducts($product_references, $get_data, $file_type, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewOrders operation/method
 */
if ($get->GetNewOrders($auto_update, $file_type, $channel, $limt, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrder operation/method
 */
if ($get->GetOrder($order_ref, $order_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrdersByDateRange operation/method
 */
if ($get->GetOrdersByDateRange($from_date, $to_date, $successful_only, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedOrders operation/method
 */
if ($get->GetUpdatedOrders($mins_since, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrders operation/method
 */
if ($get->GetOrders($ArrayOfOrders) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomer operation/method
 */
if ($get->GetCustomer($int) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomers operation/method
 */
if ($get->GetCustomers($match_mode, $lookup) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedCustomers operation/method
 */
if ($get->GetUpdatedCustomers($interval, $timestamp, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountries operation/method
 */
if ($get->GetCountries() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEwallet operation/method
 */
if ($get->GetEwallet($CustomerType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerGroups operation/method
 */
if ($get->GetCustomerGroups($limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTradeDiscounts operation/method
 */
if ($get->GetTradeDiscounts($limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebsites operation/method
 */
if ($get->GetWebsites() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewsletterMailingLists operation/method
 */
if ($get->GetNewsletterMailingLists($limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewsletterMailingListSubscribers operation/method
 */
if ($get->GetNewsletterMailingListSubscribers($mailing_list_id, $limit, $offset, $rebuild_list_first) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewsletterSubscriberGroups operation/method
 */
if ($get->GetNewsletterSubscriberGroups($limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewsletterSubscriberGroupSubscribers operation/method
 */
if ($get->GetNewsletterSubscriberGroupSubscribers($subscriber_group_id, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewsletterSubscriber operation/method
 */
if ($get->GetNewsletterSubscriber($email_address, $website_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedProducts operation/method
 */
if ($get->GetUpdatedProducts($date_time, $include_stock_updates, $get_data, $file_type, $limit, $offset) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for AddStock operation/method
 */
if ($add->AddStock($product_reference, $stock_to_add) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCustomerGroup operation/method
 */
if ($add->AddCustomerGroup($AddCustomerGroupType) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTradeDiscount operation/method
 */
if ($add->AddTradeDiscount($AddTradeDiscountType) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddNewsletterSubscriber operation/method
 */
if ($add->AddNewsletterSubscriber($NewsletterSubscriberType) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for SetStock operation/method
 */
if ($set->SetStock($product_reference, $stock_level) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetProductSortOrders operation/method
 */
if ($set->SetProductSortOrders($string) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStockInLocation operation/method
 */
if ($set->SetStockInLocation($product_reference, $stock_level, $stock_location, $allow_minus_one_change) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStockMultiple operation/method
 */
if ($set->SetStockMultiple($SetStockMultipleType) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
$import->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for ImportOrders operation/method
 */
if ($import->ImportOrders($string) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportCustomer operation/method
 */
if ($import->ImportCustomer($ImportCustomerType) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for RemoveStock operation/method
 */
if ($remove->RemoveStock($product_reference, $stock_to_remove) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
$submit->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for SubmitProducts operation/method
 */
if ($submit->SubmitProducts($ProductContainerType) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitProductsData operation/method
 */
if ($submit->SubmitProductsData($products_data, $data_type, $check_only) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
$mark->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for MarkOrdersAsDownloaded operation/method
 */
if ($mark->MarkOrdersAsDownloaded($OrderIds) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
$order->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for OrderStatusUpdate operation/method
 */
if ($order->OrderStatusUpdate($order_update_data, $data_type) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderProductStatusUpdate operation/method
 */
if ($order->OrderProductStatusUpdate($order_update_data, $data_type) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderFraudStatusUpdate operation/method
 */
if ($order->OrderFraudStatusUpdate($OrderFraudUpdateType) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Ewallet ServiceType
 */
$ewallet = new \ServiceType\Ewallet($options);
$ewallet->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for EwalletTransaction operation/method
 */
if ($ewallet->EwalletTransaction($CustomerType) !== false) {
    print_r($ewallet->getResult());
} else {
    print_r($ewallet->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
$modify->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for ModifyCustomerGroup operation/method
 */
if ($modify->ModifyCustomerGroup($AddCustomerGroupType) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyTradeDiscount operation/method
 */
if ($modify->ModifyTradeDiscount($AddTradeDiscountType) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyNewsletterSubscriber operation/method
 */
if ($modify->ModifyNewsletterSubscriber($ModifyNewsletterSubscriberType) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderVSAuthType($VSAuthType);
/**
 * Sample call for ChangeProductStockMessage operation/method
 */
if ($change->ChangeProductStockMessage($product_identifier, $stock_message_identifier, $using_product_reference, $using_stock_message_name, $website_id) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
