<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(VSAuthType $vSAuthType, $nameSpace = 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns product data in the specified format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $product_references
     * @param string $get_data
     * @param string $file_type
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetProducts($product_references, $get_data, $file_type, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProducts($product_references, $get_data, $file_type, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns all new orders that have not been marked as 'downloaded' yet. By default, this will return new orders since the last request call to this method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $auto_update
     * @param string $file_type
     * @param string $channel
     * @param string $limt
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetNewOrders($auto_update, $file_type, $channel, $limt, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewOrders($auto_update, $file_type, $channel, $limt, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns the order for the given order id or order reference.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $order_ref
     * @param string $order_id
     * @return ResultType|bool
     */
    public function GetOrder($order_ref, $order_id)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrder($order_ref, $order_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrdersByDateRange
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns all successful orders within the given date ranges. To return all orders, and not just successful ones, pass through false in the successful_only parameter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $from_date
     * @param string $to_date
     * @param string $successful_only
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetOrdersByDateRange($from_date, $to_date, $successful_only, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrdersByDateRange($from_date, $to_date, $successful_only, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns all new orders that have already been downloaded, but have been modified within the given timeframe.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mins_since
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetUpdatedOrders($mins_since, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedOrders($mins_since, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns the orders for the given order ids or order references.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ArrayOfOrders $arrayOfOrders
     * @return ResultType|bool
     */
    public function GetOrders($arrayOfOrders)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrders($arrayOfOrders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns a customer for the given ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param int $int
     * @return ResultType|bool
     */
    public function GetCustomer($int)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomer($int));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns the customers matching the lookup value according to the match mode ('account_number', 'email' or 'address').
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $match_mode
     * @param string $lookup
     * @return ResultType|bool
     */
    public function GetCustomers($match_mode, $lookup)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomers($match_mode, $lookup));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedCustomers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns customers updated in the given timeframe. Default one hour.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $interval
     * @param string $timestamp
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetUpdatedCustomers($interval, $timestamp, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedCustomers($interval, $timestamp, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Returns all active countries.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return ResultType|bool
     */
    public function GetCountries()
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEwallet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Get a customer's ewallet balance and logs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CustomerType $customerType
     * @return ResultType|bool
     */
    public function GetEwallet($customerType)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEwallet($customerType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of Customer Groups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $limit
     * @param string $offset
     * @return ArrayOfCustomerGroups|bool
     */
    public function GetCustomerGroups($limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerGroups($limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTradeDiscounts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of Trade Discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $limit
     * @param string $offset
     * @return ArrayOfTradeDiscounts|bool
     */
    public function GetTradeDiscounts($limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTradeDiscounts($limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebsites
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of Websites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return ArrayOfWebsites|bool
     */
    public function GetWebsites()
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebsites());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewsletterMailingLists
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of Newsletter Mailing Lists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetNewsletterMailingLists($limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewsletterMailingLists($limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetNewsletterMailingListSubscribers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch Newsletter subscribers from a Newsletter Mailing Lists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mailing_list_id
     * @param string $limit
     * @param string $offset
     * @param string $rebuild_list_first
     * @return ResultType|bool
     */
    public function GetNewsletterMailingListSubscribers($mailing_list_id, $limit, $offset, $rebuild_list_first)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewsletterMailingListSubscribers($mailing_list_id, $limit, $offset, $rebuild_list_first));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewsletterSubscriberGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of Newsletter Subscriber Groups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetNewsletterSubscriberGroups($limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewsletterSubscriberGroups($limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetNewsletterSubscriberGroupSubscribers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch Newsletter subscribers from a Newsletter Subscriber Group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $subscriber_group_id
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetNewsletterSubscriberGroupSubscribers($subscriber_group_id, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewsletterSubscriberGroupSubscribers($subscriber_group_id, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewsletterSubscriber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Fetch details of a Newsletter subscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $email_address
     * @param string $website_id
     * @return ResultType|bool
     */
    public function GetNewsletterSubscriber($email_address, $website_id)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewsletterSubscriber($email_address, $website_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Get details of products updated after a specific date / time
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $date_time
     * @param string $include_stock_updates
     * @param string $get_data
     * @param string $file_type
     * @param string $limit
     * @param string $offset
     * @return ResultType|bool
     */
    public function GetUpdatedProducts($date_time, $include_stock_updates, $get_data, $file_type, $limit, $offset)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedProducts($date_time, $include_stock_updates, $get_data, $file_type, $limit, $offset));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ArrayOfCustomerGroups|ArrayOfTradeDiscounts|ArrayOfWebsites|ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
