<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(VSAuthType $vSAuthType, $nameSpace = 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddStock
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Increase the stock level, by the given amount, for the given product reference.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $product_reference
     * @param string $stock_to_add
     * @return ResultType|bool
     */
    public function AddStock($product_reference, $stock_to_add)
    {
        try {
            $this->setResult($this->getSoapClient()->AddStock($product_reference, $stock_to_add));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a Customer Group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddCustomerGroupType $addCustomerGroupType
     * @return ResultType|bool
     */
    public function AddCustomerGroup($addCustomerGroupType)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomerGroup($addCustomerGroupType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTradeDiscount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a new Trade Discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddTradeDiscountType $addTradeDiscountType
     * @return ResultType|bool
     */
    public function AddTradeDiscount($addTradeDiscountType)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTradeDiscount($addTradeDiscountType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddNewsletterSubscriber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a Newsletter subscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param NewsletterSubscriberType $newsletterSubscriberType
     * @return ResultType|bool
     */
    public function AddNewsletterSubscriber($newsletterSubscriberType)
    {
        try {
            $this->setResult($this->getSoapClient()->AddNewsletterSubscriber($newsletterSubscriberType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
