<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(VSAuthType $vSAuthType, $nameSpace = 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SubmitProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Imports the given product data into the system. The data must follow the schema provided in the web service description.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ProductContainerType $productContainerType
     * @return ResultType|bool
     */
    public function SubmitProducts($productContainerType)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitProducts($productContainerType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitProductsData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Imports the given product data into the system. If check_only is provided as FALSE, this will return the result of the analysis on the products_data and add this submission to the import queue to process asynchronously. Use
     * CheckSubmitProgress to verify whether the import was completed and whether it was successful.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $products_data
     * @param string $data_type
     * @param string $check_only
     * @return ResultType|bool
     */
    public function SubmitProductsData($products_data, $data_type, $check_only)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitProductsData($products_data, $data_type, $check_only));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
