<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(VSAuthType $vSAuthType, $nameSpace = 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OrderStatusUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update a set of orders to a given order status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $order_update_data
     * @param string $data_type
     * @return ResultType|bool
     */
    public function OrderStatusUpdate($order_update_data, $data_type)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderStatusUpdate($order_update_data, $data_type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderProductStatusUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update a set of order products to a given order product status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $order_update_data
     * @param string $data_type
     * @return ResultType|bool
     */
    public function OrderProductStatusUpdate($order_update_data, $data_type)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderProductStatusUpdate($order_update_data, $data_type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderFraudStatusUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update Fraud status of an order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OrderFraudUpdateType $orderFraudUpdateType
     * @return ResultType|bool
     */
    public function OrderFraudStatusUpdate($orderFraudUpdateType)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderFraudStatusUpdate($orderFraudUpdateType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
