<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(VSAuthType $vSAuthType, $nameSpace = 'https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ModifyCustomerGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Modify an existing Customer Group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddCustomerGroupType $addCustomerGroupType
     * @return ResultType|bool
     */
    public function ModifyCustomerGroup($addCustomerGroupType)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyCustomerGroup($addCustomerGroupType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifyTradeDiscount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update an existing Trade Discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddTradeDiscountType $addTradeDiscountType
     * @return ResultType|bool
     */
    public function ModifyTradeDiscount($addTradeDiscountType)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyTradeDiscount($addTradeDiscountType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifyNewsletterSubscriber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://thebeadshop.dev.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: VSAuthType
     * - SOAPHeaders: required
     * - documentation: Modify an existing Newsletter subscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ModifyNewsletterSubscriberType $modifyNewsletterSubscriberType
     * @return ResultType|bool
     */
    public function ModifyNewsletterSubscriber($modifyNewsletterSubscriberType)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyNewsletterSubscriber($modifyNewsletterSubscriberType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
