<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZapytaniePullTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Ogolny, abstrakcyjny typ zapytania metod PULL Poszczegolne zapytania metod PULL dziedzicza z tego typu.
 * @subpackage Structs
 */
class ZapytaniePullTyp extends AbstractStructBase
{
    /**
     * The podmiot
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * @var string
     */
    public $podmiot;
    /**
     * The nazwaSkrytki
     * @var string
     */
    public $nazwaSkrytki;
    /**
     * The adresSkrytki
     * @var string
     */
    public $adresSkrytki;
    /**
     * Constructor method for ZapytaniePullTyp
     * @uses ZapytaniePullTyp::setPodmiot()
     * @uses ZapytaniePullTyp::setNazwaSkrytki()
     * @uses ZapytaniePullTyp::setAdresSkrytki()
     * @param string $podmiot
     * @param string $nazwaSkrytki
     * @param string $adresSkrytki
     */
    public function __construct($podmiot = null, $nazwaSkrytki = null, $adresSkrytki = null)
    {
        $this
            ->setPodmiot($podmiot)
            ->setNazwaSkrytki($nazwaSkrytki)
            ->setAdresSkrytki($adresSkrytki);
    }
    /**
     * Get podmiot value
     * @return string|null
     */
    public function getPodmiot()
    {
        return $this->podmiot;
    }
    /**
     * Set podmiot value
     * @param string $podmiot
     * @return \StructType\ZapytaniePullTyp
     */
    public function setPodmiot($podmiot = null)
    {
        // validation for constraint: string
        if (!is_null($podmiot) && !is_string($podmiot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podmiot, true), gettype($podmiot)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($podmiot) && mb_strlen($podmiot) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($podmiot)), __LINE__);
        }
        $this->podmiot = $podmiot;
        return $this;
    }
    /**
     * Get nazwaSkrytki value
     * @return string|null
     */
    public function getNazwaSkrytki()
    {
        return $this->nazwaSkrytki;
    }
    /**
     * Set nazwaSkrytki value
     * @param string $nazwaSkrytki
     * @return \StructType\ZapytaniePullTyp
     */
    public function setNazwaSkrytki($nazwaSkrytki = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaSkrytki) && !is_string($nazwaSkrytki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaSkrytki, true), gettype($nazwaSkrytki)), __LINE__);
        }
        $this->nazwaSkrytki = $nazwaSkrytki;
        return $this;
    }
    /**
     * Get adresSkrytki value
     * @return string|null
     */
    public function getAdresSkrytki()
    {
        return $this->adresSkrytki;
    }
    /**
     * Set adresSkrytki value
     * @param string $adresSkrytki
     * @return \StructType\ZapytaniePullTyp
     */
    public function setAdresSkrytki($adresSkrytki = null)
    {
        // validation for constraint: string
        if (!is_null($adresSkrytki) && !is_string($adresSkrytki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresSkrytki, true), gettype($adresSkrytki)), __LINE__);
        }
        $this->adresSkrytki = $adresSkrytki;
        return $this;
    }
}
