<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZapytanieDajUppTyp StructType
 * @subpackage Structs
 */
class ZapytanieDajUppTyp extends AbstractStructBase
{
    /**
     * The podmiot
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * @var string
     */
    public $podmiot;
    /**
     * The nadawca
     * @var \StructType\UzytkownikTyp
     */
    public $nadawca;
    /**
     * The dokument
     * @var \StructType\DokumentTyp
     */
    public $dokument;
    /**
     * Constructor method for ZapytanieDajUppTyp
     * @uses ZapytanieDajUppTyp::setPodmiot()
     * @uses ZapytanieDajUppTyp::setNadawca()
     * @uses ZapytanieDajUppTyp::setDokument()
     * @param string $podmiot
     * @param \StructType\UzytkownikTyp $nadawca
     * @param \StructType\DokumentTyp $dokument
     */
    public function __construct($podmiot = null, \StructType\UzytkownikTyp $nadawca = null, \StructType\DokumentTyp $dokument = null)
    {
        $this
            ->setPodmiot($podmiot)
            ->setNadawca($nadawca)
            ->setDokument($dokument);
    }
    /**
     * Get podmiot value
     * @return string|null
     */
    public function getPodmiot()
    {
        return $this->podmiot;
    }
    /**
     * Set podmiot value
     * @param string $podmiot
     * @return \StructType\ZapytanieDajUppTyp
     */
    public function setPodmiot($podmiot = null)
    {
        // validation for constraint: string
        if (!is_null($podmiot) && !is_string($podmiot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podmiot, true), gettype($podmiot)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($podmiot) && mb_strlen($podmiot) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($podmiot)), __LINE__);
        }
        $this->podmiot = $podmiot;
        return $this;
    }
    /**
     * Get nadawca value
     * @return \StructType\UzytkownikTyp|null
     */
    public function getNadawca()
    {
        return $this->nadawca;
    }
    /**
     * Set nadawca value
     * @param \StructType\UzytkownikTyp $nadawca
     * @return \StructType\ZapytanieDajUppTyp
     */
    public function setNadawca(\StructType\UzytkownikTyp $nadawca = null)
    {
        $this->nadawca = $nadawca;
        return $this;
    }
    /**
     * Get dokument value
     * @return \StructType\DokumentTyp|null
     */
    public function getDokument()
    {
        return $this->dokument;
    }
    /**
     * Set dokument value
     * @param \StructType\DokumentTyp $dokument
     * @return \StructType\ZapytanieDajUppTyp
     */
    public function setDokument(\StructType\DokumentTyp $dokument = null)
    {
        $this->dokument = $dokument;
        return $this;
    }
}
