<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZapytanieDajUppPrzeslijTyp StructType
 * @subpackage Structs
 */
class ZapytanieDajUppPrzeslijTyp extends AbstractStructBase
{
    /**
     * The podmiot
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * @var string
     */
    public $podmiot;
    /**
     * The adresSkrytki
     * @var string
     */
    public $adresSkrytki;
    /**
     * The adresOdpowiedzi
     * @var string
     */
    public $adresOdpowiedzi;
    /**
     * The dokument
     * @var \StructType\DokumentTyp
     */
    public $dokument;
    /**
     * Constructor method for ZapytanieDajUppPrzeslijTyp
     * @uses ZapytanieDajUppPrzeslijTyp::setPodmiot()
     * @uses ZapytanieDajUppPrzeslijTyp::setAdresSkrytki()
     * @uses ZapytanieDajUppPrzeslijTyp::setAdresOdpowiedzi()
     * @uses ZapytanieDajUppPrzeslijTyp::setDokument()
     * @param string $podmiot
     * @param string $adresSkrytki
     * @param string $adresOdpowiedzi
     * @param \StructType\DokumentTyp $dokument
     */
    public function __construct($podmiot = null, $adresSkrytki = null, $adresOdpowiedzi = null, \StructType\DokumentTyp $dokument = null)
    {
        $this
            ->setPodmiot($podmiot)
            ->setAdresSkrytki($adresSkrytki)
            ->setAdresOdpowiedzi($adresOdpowiedzi)
            ->setDokument($dokument);
    }
    /**
     * Get podmiot value
     * @return string|null
     */
    public function getPodmiot()
    {
        return $this->podmiot;
    }
    /**
     * Set podmiot value
     * @param string $podmiot
     * @return \StructType\ZapytanieDajUppPrzeslijTyp
     */
    public function setPodmiot($podmiot = null)
    {
        // validation for constraint: string
        if (!is_null($podmiot) && !is_string($podmiot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podmiot, true), gettype($podmiot)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($podmiot) && mb_strlen($podmiot) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($podmiot)), __LINE__);
        }
        $this->podmiot = $podmiot;
        return $this;
    }
    /**
     * Get adresSkrytki value
     * @return string|null
     */
    public function getAdresSkrytki()
    {
        return $this->adresSkrytki;
    }
    /**
     * Set adresSkrytki value
     * @param string $adresSkrytki
     * @return \StructType\ZapytanieDajUppPrzeslijTyp
     */
    public function setAdresSkrytki($adresSkrytki = null)
    {
        // validation for constraint: string
        if (!is_null($adresSkrytki) && !is_string($adresSkrytki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresSkrytki, true), gettype($adresSkrytki)), __LINE__);
        }
        $this->adresSkrytki = $adresSkrytki;
        return $this;
    }
    /**
     * Get adresOdpowiedzi value
     * @return string|null
     */
    public function getAdresOdpowiedzi()
    {
        return $this->adresOdpowiedzi;
    }
    /**
     * Set adresOdpowiedzi value
     * @param string $adresOdpowiedzi
     * @return \StructType\ZapytanieDajUppPrzeslijTyp
     */
    public function setAdresOdpowiedzi($adresOdpowiedzi = null)
    {
        // validation for constraint: string
        if (!is_null($adresOdpowiedzi) && !is_string($adresOdpowiedzi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresOdpowiedzi, true), gettype($adresOdpowiedzi)), __LINE__);
        }
        $this->adresOdpowiedzi = $adresOdpowiedzi;
        return $this;
    }
    /**
     * Get dokument value
     * @return \StructType\DokumentTyp|null
     */
    public function getDokument()
    {
        return $this->dokument;
    }
    /**
     * Set dokument value
     * @param \StructType\DokumentTyp $dokument
     * @return \StructType\ZapytanieDajUppPrzeslijTyp
     */
    public function setDokument(\StructType\DokumentTyp $dokument = null)
    {
        $this->dokument = $dokument;
        return $this;
    }
}
