<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.epuap.gov.pl/pk_external_ws/services/skrytka/wsdl/skrytka.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.epuap.gov.pl/pk_external_ws/services/skrytka/wsdl/skrytka.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Nadaj ServiceType
 */
$nadaj = new \ServiceType\Nadaj($options);
$nadaj->setSoapHeaderIdentyfikatorPodmiotu($IdentyfikatorPodmiotu);
$nadaj->setSoapHeaderAdresSkrytki($AdresSkrytki);
$nadaj->setSoapHeaderAdresOdpowiedzi($AdresOdpowiedzi);
$nadaj->setSoapHeaderCzyProbne($CzyProbne);
$nadaj->setSoapHeaderDaneDodatkowe($DaneDodatkowe);
$nadaj->setSoapHeaderNazwaPliku($NazwaPliku);
/**
 * Sample call for nadaj operation/method
 */
if ($nadaj->nadaj(new \StructType\DokumentTyp()) !== false) {
    print_r($nadaj->getResult());
} else {
    print_r($nadaj->getLastError());
}
/**
 * Sample call for nadajAny operation/method
 */
if ($nadaj->nadajAny($dokument) !== false) {
    print_r($nadaj->getResult());
} else {
    print_r($nadaj->getLastError());
}
