<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WyjatekTyp StructType
 * @subpackage Structs
 */
class WyjatekTyp extends AbstractStructBase
{
    /**
     * The kod
     * @var int
     */
    public $kod;
    /**
     * The komunikat
     * @var string
     */
    public $komunikat;
    /**
     * Constructor method for WyjatekTyp
     * @uses WyjatekTyp::setKod()
     * @uses WyjatekTyp::setKomunikat()
     * @param int $kod
     * @param string $komunikat
     */
    public function __construct($kod = null, $komunikat = null)
    {
        $this
            ->setKod($kod)
            ->setKomunikat($komunikat);
    }
    /**
     * Get kod value
     * @return int|null
     */
    public function getKod()
    {
        return $this->kod;
    }
    /**
     * Set kod value
     * @param int $kod
     * @return \StructType\WyjatekTyp
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !(is_int($kod) || ctype_digit($kod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->kod = $kod;
        return $this;
    }
    /**
     * Get komunikat value
     * @return string|null
     */
    public function getKomunikat()
    {
        return $this->komunikat;
    }
    /**
     * Set komunikat value
     * @param string $komunikat
     * @return \StructType\WyjatekTyp
     */
    public function setKomunikat($komunikat = null)
    {
        // validation for constraint: string
        if (!is_null($komunikat) && !is_string($komunikat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($komunikat, true), gettype($komunikat)), __LINE__);
        }
        $this->komunikat = $komunikat;
        return $this;
    }
}
