<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusTyp StructType
 * @subpackage Structs
 */
class StatusTyp extends AbstractStructBase
{
    /**
     * The kod
     * @var int
     */
    public $kod;
    /**
     * The komunikat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $komunikat;
    /**
     * Constructor method for StatusTyp
     * @uses StatusTyp::setKod()
     * @uses StatusTyp::setKomunikat()
     * @param int $kod
     * @param string $komunikat
     */
    public function __construct($kod = null, $komunikat = null)
    {
        $this
            ->setKod($kod)
            ->setKomunikat($komunikat);
    }
    /**
     * Get kod value
     * @return int|null
     */
    public function getKod()
    {
        return $this->kod;
    }
    /**
     * Set kod value
     * @param int $kod
     * @return \StructType\StatusTyp
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !(is_int($kod) || ctype_digit($kod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->kod = $kod;
        return $this;
    }
    /**
     * Get komunikat value
     * @return string|null
     */
    public function getKomunikat()
    {
        return $this->komunikat;
    }
    /**
     * Set komunikat value
     * @param string $komunikat
     * @return \StructType\StatusTyp
     */
    public function setKomunikat($komunikat = null)
    {
        // validation for constraint: string
        if (!is_null($komunikat) && !is_string($komunikat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($komunikat, true), gettype($komunikat)), __LINE__);
        }
        $this->komunikat = $komunikat;
        return $this;
    }
}
