<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nadaj ServiceType
 * @subpackage Services
 */
class Nadaj extends AbstractSoapClientBase
{
    /**
     * Sets the IdentyfikatorPodmiotu SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param string $identyfikatorPodmiotu
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderIdentyfikatorPodmiotu($identyfikatorPodmiotu, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        // validation for constraint: string
        if (!is_null($identyfikatorPodmiotu) && !is_string($identyfikatorPodmiotu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identyfikatorPodmiotu, true), gettype($identyfikatorPodmiotu)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($identyfikatorPodmiotu) && mb_strlen($identyfikatorPodmiotu) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($identyfikatorPodmiotu)), __LINE__);
        }
        return $this->setSoapHeader($nameSpace, 'IdentyfikatorPodmiotu', $identyfikatorPodmiotu, $mustUnderstand, $actor);
    }
    /**
     * Sets the AdresSkrytki SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $adresSkrytki
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAdresSkrytki($adresSkrytki, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AdresSkrytki', $adresSkrytki, $mustUnderstand, $actor);
    }
    /**
     * Sets the AdresOdpowiedzi SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $adresOdpowiedzi
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAdresOdpowiedzi($adresOdpowiedzi, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AdresOdpowiedzi', $adresOdpowiedzi, $mustUnderstand, $actor);
    }
    /**
     * Sets the CzyProbne SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $czyProbne
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCzyProbne($czyProbne, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CzyProbne', $czyProbne, $mustUnderstand, $actor);
    }
    /**
     * Sets the DaneDodatkowe SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $daneDodatkowe
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDaneDodatkowe($daneDodatkowe, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DaneDodatkowe', $daneDodatkowe, $mustUnderstand, $actor);
    }
    /**
     * Sets the NazwaPliku SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $nazwaPliku
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderNazwaPliku($nazwaPliku, $nameSpace = 'http://ws.epuap.gov.pl/skrytka/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'NazwaPliku', $nazwaPliku, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named nadaj
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: IdentyfikatorPodmiotu, AdresSkrytki, AdresOdpowiedzi, CzyProbne, DaneDodatkowe
     * - SOAPHeaderNamespaces: http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/
     * - SOAPHeaderTypes: \StructType\IdentyfikatorPodmiotuTyp, string, string, boolean, base64Binary
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DokumentTyp $dokument
     * @return \StructType\OdpowiedzSkrytkiTyp|bool
     */
    public function nadaj(\StructType\DokumentTyp $dokument)
    {
        try {
            $this->setResult($this->getSoapClient()->nadaj($dokument));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nadajAny
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: IdentyfikatorPodmiotu, AdresSkrytki, AdresOdpowiedzi, CzyProbne, DaneDodatkowe, NazwaPliku
     * - SOAPHeaderNamespaces: http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/, http://ws.epuap.gov.pl/skrytka/
     * - SOAPHeaderTypes: \StructType\IdentyfikatorPodmiotuTyp, string, string, boolean, base64Binary, string
     * - SOAPHeaders: required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $dokument
     * @return \StructType\OdpowiedzSkrytkiTyp|bool
     */
    public function nadajAny($dokument)
    {
        try {
            $this->setResult($this->getSoapClient()->nadajAny($dokument));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OdpowiedzSkrytkiTyp
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
