<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipesClientSave StructType
 * @subpackage Structs
 */
class RecipesClientSave extends AbstractStructBase
{
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The recipes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRecipeClient
     */
    public $recipes;
    /**
     * Constructor method for RecipesClientSave
     * @uses RecipesClientSave::setClientId()
     * @uses RecipesClientSave::setRecipes()
     * @param string $clientId
     * @param \ArrayType\ArrayOfRecipeClient $recipes
     */
    public function __construct($clientId = null, \ArrayType\ArrayOfRecipeClient $recipes = null)
    {
        $this
            ->setClientId($clientId)
            ->setRecipes($recipes);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipesClientSave
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get recipes value
     * @return \ArrayType\ArrayOfRecipeClient|null
     */
    public function getRecipes()
    {
        return $this->recipes;
    }
    /**
     * Set recipes value
     * @param \ArrayType\ArrayOfRecipeClient $recipes
     * @return \StructType\RecipesClientSave
     */
    public function setRecipes(\ArrayType\ArrayOfRecipeClient $recipes = null)
    {
        $this->recipes = $recipes;
        return $this;
    }
}
