<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipesClientHashesExchange StructType
 * @subpackage Structs
 */
class RecipesClientHashesExchange extends AbstractStructBase
{
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The documentHashes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocumentHash
     */
    public $documentHashes;
    /**
     * Constructor method for RecipesClientHashesExchange
     * @uses RecipesClientHashesExchange::setClientId()
     * @uses RecipesClientHashesExchange::setDocumentHashes()
     * @param string $clientId
     * @param \ArrayType\ArrayOfDocumentHash $documentHashes
     */
    public function __construct($clientId = null, \ArrayType\ArrayOfDocumentHash $documentHashes = null)
    {
        $this
            ->setClientId($clientId)
            ->setDocumentHashes($documentHashes);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipesClientHashesExchange
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get documentHashes value
     * @return \ArrayType\ArrayOfDocumentHash|null
     */
    public function getDocumentHashes()
    {
        return $this->documentHashes;
    }
    /**
     * Set documentHashes value
     * @param \ArrayType\ArrayOfDocumentHash $documentHashes
     * @return \StructType\RecipesClientHashesExchange
     */
    public function setDocumentHashes(\ArrayType\ArrayOfDocumentHash $documentHashes = null)
    {
        $this->documentHashes = $documentHashes;
        return $this;
    }
}
