<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeResponseInfo StructType
 * @subpackage Structs
 */
class RecipeResponseInfo extends AbstractStructBase
{
    /**
     * The RetailPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RetailPrice;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Denominator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Denominator;
    /**
     * The CallDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CallDate;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The UnifyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnifyId;
    /**
     * The ContractorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractorId;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierId;
    /**
     * The IdGosContract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdGosContract;
    /**
     * The IdGosContractGoods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdGosContractGoods;
    /**
     * The IdChequeItemGlobal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdChequeItemGlobal;
    /**
     * The IdLotGlobal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdLotGlobal;
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaleDate;
    /**
     * The ChequeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChequeDate;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The SmsPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SmsPhone;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for RecipeResponseInfo
     * @uses RecipeResponseInfo::setRetailPrice()
     * @uses RecipeResponseInfo::setQuantity()
     * @uses RecipeResponseInfo::setDenominator()
     * @uses RecipeResponseInfo::setCallDate()
     * @uses RecipeResponseInfo::setId()
     * @uses RecipeResponseInfo::setCode()
     * @uses RecipeResponseInfo::setUnifyId()
     * @uses RecipeResponseInfo::setContractorId()
     * @uses RecipeResponseInfo::setSupplierId()
     * @uses RecipeResponseInfo::setIdGosContract()
     * @uses RecipeResponseInfo::setIdGosContractGoods()
     * @uses RecipeResponseInfo::setIdChequeItemGlobal()
     * @uses RecipeResponseInfo::setIdLotGlobal()
     * @uses RecipeResponseInfo::setSaleDate()
     * @uses RecipeResponseInfo::setChequeDate()
     * @uses RecipeResponseInfo::setNote()
     * @uses RecipeResponseInfo::setSmsPhone()
     * @uses RecipeResponseInfo::setUserLogin()
     * @uses RecipeResponseInfo::setUserName()
     * @param float $retailPrice
     * @param float $quantity
     * @param int $denominator
     * @param string $callDate
     * @param string $id
     * @param string $code
     * @param string $unifyId
     * @param string $contractorId
     * @param string $supplierId
     * @param string $idGosContract
     * @param string $idGosContractGoods
     * @param string $idChequeItemGlobal
     * @param string $idLotGlobal
     * @param string $saleDate
     * @param string $chequeDate
     * @param string $note
     * @param string $smsPhone
     * @param string $userLogin
     * @param string $userName
     */
    public function __construct($retailPrice = null, $quantity = null, $denominator = null, $callDate = null, $id = null, $code = null, $unifyId = null, $contractorId = null, $supplierId = null, $idGosContract = null, $idGosContractGoods = null, $idChequeItemGlobal = null, $idLotGlobal = null, $saleDate = null, $chequeDate = null, $note = null, $smsPhone = null, $userLogin = null, $userName = null)
    {
        $this
            ->setRetailPrice($retailPrice)
            ->setQuantity($quantity)
            ->setDenominator($denominator)
            ->setCallDate($callDate)
            ->setId($id)
            ->setCode($code)
            ->setUnifyId($unifyId)
            ->setContractorId($contractorId)
            ->setSupplierId($supplierId)
            ->setIdGosContract($idGosContract)
            ->setIdGosContractGoods($idGosContractGoods)
            ->setIdChequeItemGlobal($idChequeItemGlobal)
            ->setIdLotGlobal($idLotGlobal)
            ->setSaleDate($saleDate)
            ->setChequeDate($chequeDate)
            ->setNote($note)
            ->setSmsPhone($smsPhone)
            ->setUserLogin($userLogin)
            ->setUserName($userName);
    }
    /**
     * Get RetailPrice value
     * @return float
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param float $retailPrice
     * @return \StructType\RecipeResponseInfo
     */
    public function setRetailPrice($retailPrice = null)
    {
        // validation for constraint: float
        if (!is_null($retailPrice) && !(is_float($retailPrice) || is_numeric($retailPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retailPrice, true), gettype($retailPrice)), __LINE__);
        }
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\RecipeResponseInfo
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Denominator value
     * @return int
     */
    public function getDenominator()
    {
        return $this->Denominator;
    }
    /**
     * Set Denominator value
     * @param int $denominator
     * @return \StructType\RecipeResponseInfo
     */
    public function setDenominator($denominator = null)
    {
        // validation for constraint: int
        if (!is_null($denominator) && !(is_int($denominator) || ctype_digit($denominator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($denominator, true), gettype($denominator)), __LINE__);
        }
        $this->Denominator = $denominator;
        return $this;
    }
    /**
     * Get CallDate value
     * @return string
     */
    public function getCallDate()
    {
        return $this->CallDate;
    }
    /**
     * Set CallDate value
     * @param string $callDate
     * @return \StructType\RecipeResponseInfo
     */
    public function setCallDate($callDate = null)
    {
        // validation for constraint: string
        if (!is_null($callDate) && !is_string($callDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callDate, true), gettype($callDate)), __LINE__);
        }
        $this->CallDate = $callDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RecipeResponseInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\RecipeResponseInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get UnifyId value
     * @return string|null
     */
    public function getUnifyId()
    {
        return $this->UnifyId;
    }
    /**
     * Set UnifyId value
     * @param string $unifyId
     * @return \StructType\RecipeResponseInfo
     */
    public function setUnifyId($unifyId = null)
    {
        // validation for constraint: string
        if (!is_null($unifyId) && !is_string($unifyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unifyId, true), gettype($unifyId)), __LINE__);
        }
        $this->UnifyId = $unifyId;
        return $this;
    }
    /**
     * Get ContractorId value
     * @return string|null
     */
    public function getContractorId()
    {
        return $this->ContractorId;
    }
    /**
     * Set ContractorId value
     * @param string $contractorId
     * @return \StructType\RecipeResponseInfo
     */
    public function setContractorId($contractorId = null)
    {
        // validation for constraint: string
        if (!is_null($contractorId) && !is_string($contractorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractorId, true), gettype($contractorId)), __LINE__);
        }
        $this->ContractorId = $contractorId;
        return $this;
    }
    /**
     * Get SupplierId value
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param string $supplierId
     * @return \StructType\RecipeResponseInfo
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierId) && !is_string($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get IdGosContract value
     * @return string|null
     */
    public function getIdGosContract()
    {
        return $this->IdGosContract;
    }
    /**
     * Set IdGosContract value
     * @param string $idGosContract
     * @return \StructType\RecipeResponseInfo
     */
    public function setIdGosContract($idGosContract = null)
    {
        // validation for constraint: string
        if (!is_null($idGosContract) && !is_string($idGosContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idGosContract, true), gettype($idGosContract)), __LINE__);
        }
        $this->IdGosContract = $idGosContract;
        return $this;
    }
    /**
     * Get IdGosContractGoods value
     * @return string|null
     */
    public function getIdGosContractGoods()
    {
        return $this->IdGosContractGoods;
    }
    /**
     * Set IdGosContractGoods value
     * @param string $idGosContractGoods
     * @return \StructType\RecipeResponseInfo
     */
    public function setIdGosContractGoods($idGosContractGoods = null)
    {
        // validation for constraint: string
        if (!is_null($idGosContractGoods) && !is_string($idGosContractGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idGosContractGoods, true), gettype($idGosContractGoods)), __LINE__);
        }
        $this->IdGosContractGoods = $idGosContractGoods;
        return $this;
    }
    /**
     * Get IdChequeItemGlobal value
     * @return string|null
     */
    public function getIdChequeItemGlobal()
    {
        return $this->IdChequeItemGlobal;
    }
    /**
     * Set IdChequeItemGlobal value
     * @param string $idChequeItemGlobal
     * @return \StructType\RecipeResponseInfo
     */
    public function setIdChequeItemGlobal($idChequeItemGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($idChequeItemGlobal) && !is_string($idChequeItemGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idChequeItemGlobal, true), gettype($idChequeItemGlobal)), __LINE__);
        }
        $this->IdChequeItemGlobal = $idChequeItemGlobal;
        return $this;
    }
    /**
     * Get IdLotGlobal value
     * @return string|null
     */
    public function getIdLotGlobal()
    {
        return $this->IdLotGlobal;
    }
    /**
     * Set IdLotGlobal value
     * @param string $idLotGlobal
     * @return \StructType\RecipeResponseInfo
     */
    public function setIdLotGlobal($idLotGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($idLotGlobal) && !is_string($idLotGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idLotGlobal, true), gettype($idLotGlobal)), __LINE__);
        }
        $this->IdLotGlobal = $idLotGlobal;
        return $this;
    }
    /**
     * Get SaleDate value
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->SaleDate;
    }
    /**
     * Set SaleDate value
     * @param string $saleDate
     * @return \StructType\RecipeResponseInfo
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        $this->SaleDate = $saleDate;
        return $this;
    }
    /**
     * Get ChequeDate value
     * @return string|null
     */
    public function getChequeDate()
    {
        return $this->ChequeDate;
    }
    /**
     * Set ChequeDate value
     * @param string $chequeDate
     * @return \StructType\RecipeResponseInfo
     */
    public function setChequeDate($chequeDate = null)
    {
        // validation for constraint: string
        if (!is_null($chequeDate) && !is_string($chequeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeDate, true), gettype($chequeDate)), __LINE__);
        }
        $this->ChequeDate = $chequeDate;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\RecipeResponseInfo
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get SmsPhone value
     * @return string|null
     */
    public function getSmsPhone()
    {
        return $this->SmsPhone;
    }
    /**
     * Set SmsPhone value
     * @param string $smsPhone
     * @return \StructType\RecipeResponseInfo
     */
    public function setSmsPhone($smsPhone = null)
    {
        // validation for constraint: string
        if (!is_null($smsPhone) && !is_string($smsPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsPhone, true), gettype($smsPhone)), __LINE__);
        }
        $this->SmsPhone = $smsPhone;
        return $this;
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\RecipeResponseInfo
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\RecipeResponseInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
}
