<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeClientSave StructType
 * @subpackage Structs
 */
class RecipeClientSave extends AbstractStructBase
{
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The recipe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecipeClient
     */
    public $recipe;
    /**
     * Constructor method for RecipeClientSave
     * @uses RecipeClientSave::setClientId()
     * @uses RecipeClientSave::setRecipe()
     * @param string $clientId
     * @param \StructType\RecipeClient $recipe
     */
    public function __construct($clientId = null, \StructType\RecipeClient $recipe = null)
    {
        $this
            ->setClientId($clientId)
            ->setRecipe($recipe);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \StructType\RecipeClientSave
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get recipe value
     * @return \StructType\RecipeClient|null
     */
    public function getRecipe()
    {
        return $this->recipe;
    }
    /**
     * Set recipe value
     * @param \StructType\RecipeClient $recipe
     * @return \StructType\RecipeClientSave
     */
    public function setRecipe(\StructType\RecipeClient $recipe = null)
    {
        $this->recipe = $recipe;
        return $this;
    }
}
