<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeClient2Sale StructType
 * @subpackage Structs
 */
class RecipeClient2Sale extends AbstractStructBase
{
    /**
     * The IncomeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncomeDate;
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleDate;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $Details;
    /**
     * Constructor method for RecipeClient2Sale
     * @uses RecipeClient2Sale::setIncomeDate()
     * @uses RecipeClient2Sale::setSaleDate()
     * @uses RecipeClient2Sale::setDetails()
     * @param string $incomeDate
     * @param string $saleDate
     * @param \ArrayType\ArrayOfItem $details
     */
    public function __construct($incomeDate = null, $saleDate = null, \ArrayType\ArrayOfItem $details = null)
    {
        $this
            ->setIncomeDate($incomeDate)
            ->setSaleDate($saleDate)
            ->setDetails($details);
    }
    /**
     * Get IncomeDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncomeDate()
    {
        return isset($this->IncomeDate) ? $this->IncomeDate : null;
    }
    /**
     * Set IncomeDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $incomeDate
     * @return \StructType\RecipeClient2Sale
     */
    public function setIncomeDate($incomeDate = null)
    {
        // validation for constraint: string
        if (!is_null($incomeDate) && !is_string($incomeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeDate, true), gettype($incomeDate)), __LINE__);
        }
        if (is_null($incomeDate) || (is_array($incomeDate) && empty($incomeDate))) {
            unset($this->IncomeDate);
        } else {
            $this->IncomeDate = $incomeDate;
        }
        return $this;
    }
    /**
     * Get SaleDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleDate()
    {
        return isset($this->SaleDate) ? $this->SaleDate : null;
    }
    /**
     * Set SaleDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleDate
     * @return \StructType\RecipeClient2Sale
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        if (is_null($saleDate) || (is_array($saleDate) && empty($saleDate))) {
            unset($this->SaleDate);
        } else {
            $this->SaleDate = $saleDate;
        }
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfItem $details
     * @return \StructType\RecipeClient2Sale
     */
    public function setDetails(\ArrayType\ArrayOfItem $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
