<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeClient2Issue StructType
 * @subpackage Structs
 */
class RecipeClient2Issue extends AbstractStructBase
{
    /**
     * The PrivilegeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PrivilegeCode;
    /**
     * The IsVk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVk;
    /**
     * The PayPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayPercent;
    /**
     * The DoctorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorCode;
    /**
     * The LpuOgrn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LpuOgrn;
    /**
     * The LpuFoms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LpuFoms;
    /**
     * The Snils
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Snils;
    /**
     * The PatientLastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientLastname;
    /**
     * The PatientFirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientFirstname;
    /**
     * The PatientMiddlename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientMiddlename;
    /**
     * The PatientBirthday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PatientBirthday;
    /**
     * The PatientSex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatientSex;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The FundingSourceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FundingSourceCode;
    /**
     * The NosologyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NosologyCode;
    /**
     * The MkbCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MkbCode;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueDate;
    /**
     * The ValidPeriodCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidPeriodCode;
    /**
     * The MnnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MnnCode;
    /**
     * The TrnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TrnCode;
    /**
     * The Dosage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dosage;
    /**
     * The CureformCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CureformCode;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityAtom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityAtom;
    /**
     * Constructor method for RecipeClient2Issue
     * @uses RecipeClient2Issue::setPrivilegeCode()
     * @uses RecipeClient2Issue::setIsVk()
     * @uses RecipeClient2Issue::setPayPercent()
     * @uses RecipeClient2Issue::setDoctorCode()
     * @uses RecipeClient2Issue::setLpuOgrn()
     * @uses RecipeClient2Issue::setLpuFoms()
     * @uses RecipeClient2Issue::setSnils()
     * @uses RecipeClient2Issue::setPatientLastname()
     * @uses RecipeClient2Issue::setPatientFirstname()
     * @uses RecipeClient2Issue::setPatientMiddlename()
     * @uses RecipeClient2Issue::setPatientBirthday()
     * @uses RecipeClient2Issue::setPatientSex()
     * @uses RecipeClient2Issue::setProgramName()
     * @uses RecipeClient2Issue::setFundingSourceCode()
     * @uses RecipeClient2Issue::setNosologyCode()
     * @uses RecipeClient2Issue::setMkbCode()
     * @uses RecipeClient2Issue::setIssueDate()
     * @uses RecipeClient2Issue::setValidPeriodCode()
     * @uses RecipeClient2Issue::setMnnCode()
     * @uses RecipeClient2Issue::setTrnCode()
     * @uses RecipeClient2Issue::setDosage()
     * @uses RecipeClient2Issue::setCureformCode()
     * @uses RecipeClient2Issue::setQuantity()
     * @uses RecipeClient2Issue::setQuantityAtom()
     * @param int $privilegeCode
     * @param bool $isVk
     * @param int $payPercent
     * @param string $doctorCode
     * @param string $lpuOgrn
     * @param string $lpuFoms
     * @param string $snils
     * @param string $patientLastname
     * @param string $patientFirstname
     * @param string $patientMiddlename
     * @param string $patientBirthday
     * @param string $patientSex
     * @param string $programName
     * @param int $fundingSourceCode
     * @param int $nosologyCode
     * @param string $mkbCode
     * @param string $issueDate
     * @param string $validPeriodCode
     * @param int $mnnCode
     * @param int $trnCode
     * @param string $dosage
     * @param int $cureformCode
     * @param float $quantity
     * @param int $quantityAtom
     */
    public function __construct($privilegeCode = null, $isVk = null, $payPercent = null, $doctorCode = null, $lpuOgrn = null, $lpuFoms = null, $snils = null, $patientLastname = null, $patientFirstname = null, $patientMiddlename = null, $patientBirthday = null, $patientSex = null, $programName = null, $fundingSourceCode = null, $nosologyCode = null, $mkbCode = null, $issueDate = null, $validPeriodCode = null, $mnnCode = null, $trnCode = null, $dosage = null, $cureformCode = null, $quantity = null, $quantityAtom = null)
    {
        $this
            ->setPrivilegeCode($privilegeCode)
            ->setIsVk($isVk)
            ->setPayPercent($payPercent)
            ->setDoctorCode($doctorCode)
            ->setLpuOgrn($lpuOgrn)
            ->setLpuFoms($lpuFoms)
            ->setSnils($snils)
            ->setPatientLastname($patientLastname)
            ->setPatientFirstname($patientFirstname)
            ->setPatientMiddlename($patientMiddlename)
            ->setPatientBirthday($patientBirthday)
            ->setPatientSex($patientSex)
            ->setProgramName($programName)
            ->setFundingSourceCode($fundingSourceCode)
            ->setNosologyCode($nosologyCode)
            ->setMkbCode($mkbCode)
            ->setIssueDate($issueDate)
            ->setValidPeriodCode($validPeriodCode)
            ->setMnnCode($mnnCode)
            ->setTrnCode($trnCode)
            ->setDosage($dosage)
            ->setCureformCode($cureformCode)
            ->setQuantity($quantity)
            ->setQuantityAtom($quantityAtom);
    }
    /**
     * Get PrivilegeCode value
     * @return int
     */
    public function getPrivilegeCode()
    {
        return $this->PrivilegeCode;
    }
    /**
     * Set PrivilegeCode value
     * @param int $privilegeCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setPrivilegeCode($privilegeCode = null)
    {
        // validation for constraint: int
        if (!is_null($privilegeCode) && !(is_int($privilegeCode) || ctype_digit($privilegeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privilegeCode, true), gettype($privilegeCode)), __LINE__);
        }
        $this->PrivilegeCode = $privilegeCode;
        return $this;
    }
    /**
     * Get IsVk value
     * @return bool
     */
    public function getIsVk()
    {
        return $this->IsVk;
    }
    /**
     * Set IsVk value
     * @param bool $isVk
     * @return \StructType\RecipeClient2Issue
     */
    public function setIsVk($isVk = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVk) && !is_bool($isVk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVk, true), gettype($isVk)), __LINE__);
        }
        $this->IsVk = $isVk;
        return $this;
    }
    /**
     * Get PayPercent value
     * @return int
     */
    public function getPayPercent()
    {
        return $this->PayPercent;
    }
    /**
     * Set PayPercent value
     * @param int $payPercent
     * @return \StructType\RecipeClient2Issue
     */
    public function setPayPercent($payPercent = null)
    {
        // validation for constraint: int
        if (!is_null($payPercent) && !(is_int($payPercent) || ctype_digit($payPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payPercent, true), gettype($payPercent)), __LINE__);
        }
        $this->PayPercent = $payPercent;
        return $this;
    }
    /**
     * Get DoctorCode value
     * @return string|null
     */
    public function getDoctorCode()
    {
        return $this->DoctorCode;
    }
    /**
     * Set DoctorCode value
     * @param string $doctorCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setDoctorCode($doctorCode = null)
    {
        // validation for constraint: string
        if (!is_null($doctorCode) && !is_string($doctorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorCode, true), gettype($doctorCode)), __LINE__);
        }
        $this->DoctorCode = $doctorCode;
        return $this;
    }
    /**
     * Get LpuOgrn value
     * @return string|null
     */
    public function getLpuOgrn()
    {
        return $this->LpuOgrn;
    }
    /**
     * Set LpuOgrn value
     * @param string $lpuOgrn
     * @return \StructType\RecipeClient2Issue
     */
    public function setLpuOgrn($lpuOgrn = null)
    {
        // validation for constraint: string
        if (!is_null($lpuOgrn) && !is_string($lpuOgrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lpuOgrn, true), gettype($lpuOgrn)), __LINE__);
        }
        $this->LpuOgrn = $lpuOgrn;
        return $this;
    }
    /**
     * Get LpuFoms value
     * @return string|null
     */
    public function getLpuFoms()
    {
        return $this->LpuFoms;
    }
    /**
     * Set LpuFoms value
     * @param string $lpuFoms
     * @return \StructType\RecipeClient2Issue
     */
    public function setLpuFoms($lpuFoms = null)
    {
        // validation for constraint: string
        if (!is_null($lpuFoms) && !is_string($lpuFoms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lpuFoms, true), gettype($lpuFoms)), __LINE__);
        }
        $this->LpuFoms = $lpuFoms;
        return $this;
    }
    /**
     * Get Snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->Snils;
    }
    /**
     * Set Snils value
     * @param string $snils
     * @return \StructType\RecipeClient2Issue
     */
    public function setSnils($snils = null)
    {
        // validation for constraint: string
        if (!is_null($snils) && !is_string($snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snils, true), gettype($snils)), __LINE__);
        }
        $this->Snils = $snils;
        return $this;
    }
    /**
     * Get PatientLastname value
     * @return string|null
     */
    public function getPatientLastname()
    {
        return $this->PatientLastname;
    }
    /**
     * Set PatientLastname value
     * @param string $patientLastname
     * @return \StructType\RecipeClient2Issue
     */
    public function setPatientLastname($patientLastname = null)
    {
        // validation for constraint: string
        if (!is_null($patientLastname) && !is_string($patientLastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientLastname, true), gettype($patientLastname)), __LINE__);
        }
        $this->PatientLastname = $patientLastname;
        return $this;
    }
    /**
     * Get PatientFirstname value
     * @return string|null
     */
    public function getPatientFirstname()
    {
        return $this->PatientFirstname;
    }
    /**
     * Set PatientFirstname value
     * @param string $patientFirstname
     * @return \StructType\RecipeClient2Issue
     */
    public function setPatientFirstname($patientFirstname = null)
    {
        // validation for constraint: string
        if (!is_null($patientFirstname) && !is_string($patientFirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientFirstname, true), gettype($patientFirstname)), __LINE__);
        }
        $this->PatientFirstname = $patientFirstname;
        return $this;
    }
    /**
     * Get PatientMiddlename value
     * @return string|null
     */
    public function getPatientMiddlename()
    {
        return $this->PatientMiddlename;
    }
    /**
     * Set PatientMiddlename value
     * @param string $patientMiddlename
     * @return \StructType\RecipeClient2Issue
     */
    public function setPatientMiddlename($patientMiddlename = null)
    {
        // validation for constraint: string
        if (!is_null($patientMiddlename) && !is_string($patientMiddlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientMiddlename, true), gettype($patientMiddlename)), __LINE__);
        }
        $this->PatientMiddlename = $patientMiddlename;
        return $this;
    }
    /**
     * Get PatientBirthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatientBirthday()
    {
        return isset($this->PatientBirthday) ? $this->PatientBirthday : null;
    }
    /**
     * Set PatientBirthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $patientBirthday
     * @return \StructType\RecipeClient2Issue
     */
    public function setPatientBirthday($patientBirthday = null)
    {
        // validation for constraint: string
        if (!is_null($patientBirthday) && !is_string($patientBirthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientBirthday, true), gettype($patientBirthday)), __LINE__);
        }
        if (is_null($patientBirthday) || (is_array($patientBirthday) && empty($patientBirthday))) {
            unset($this->PatientBirthday);
        } else {
            $this->PatientBirthday = $patientBirthday;
        }
        return $this;
    }
    /**
     * Get PatientSex value
     * @return string|null
     */
    public function getPatientSex()
    {
        return $this->PatientSex;
    }
    /**
     * Set PatientSex value
     * @param string $patientSex
     * @return \StructType\RecipeClient2Issue
     */
    public function setPatientSex($patientSex = null)
    {
        // validation for constraint: string
        if (!is_null($patientSex) && !is_string($patientSex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientSex, true), gettype($patientSex)), __LINE__);
        }
        $this->PatientSex = $patientSex;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\RecipeClient2Issue
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get FundingSourceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFundingSourceCode()
    {
        return isset($this->FundingSourceCode) ? $this->FundingSourceCode : null;
    }
    /**
     * Set FundingSourceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fundingSourceCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setFundingSourceCode($fundingSourceCode = null)
    {
        // validation for constraint: int
        if (!is_null($fundingSourceCode) && !(is_int($fundingSourceCode) || ctype_digit($fundingSourceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fundingSourceCode, true), gettype($fundingSourceCode)), __LINE__);
        }
        if (is_null($fundingSourceCode) || (is_array($fundingSourceCode) && empty($fundingSourceCode))) {
            unset($this->FundingSourceCode);
        } else {
            $this->FundingSourceCode = $fundingSourceCode;
        }
        return $this;
    }
    /**
     * Get NosologyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNosologyCode()
    {
        return isset($this->NosologyCode) ? $this->NosologyCode : null;
    }
    /**
     * Set NosologyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nosologyCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setNosologyCode($nosologyCode = null)
    {
        // validation for constraint: int
        if (!is_null($nosologyCode) && !(is_int($nosologyCode) || ctype_digit($nosologyCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nosologyCode, true), gettype($nosologyCode)), __LINE__);
        }
        if (is_null($nosologyCode) || (is_array($nosologyCode) && empty($nosologyCode))) {
            unset($this->NosologyCode);
        } else {
            $this->NosologyCode = $nosologyCode;
        }
        return $this;
    }
    /**
     * Get MkbCode value
     * @return string|null
     */
    public function getMkbCode()
    {
        return $this->MkbCode;
    }
    /**
     * Set MkbCode value
     * @param string $mkbCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setMkbCode($mkbCode = null)
    {
        // validation for constraint: string
        if (!is_null($mkbCode) && !is_string($mkbCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mkbCode, true), gettype($mkbCode)), __LINE__);
        }
        $this->MkbCode = $mkbCode;
        return $this;
    }
    /**
     * Get IssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueDate()
    {
        return isset($this->IssueDate) ? $this->IssueDate : null;
    }
    /**
     * Set IssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueDate
     * @return \StructType\RecipeClient2Issue
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        if (is_null($issueDate) || (is_array($issueDate) && empty($issueDate))) {
            unset($this->IssueDate);
        } else {
            $this->IssueDate = $issueDate;
        }
        return $this;
    }
    /**
     * Get ValidPeriodCode value
     * @return string|null
     */
    public function getValidPeriodCode()
    {
        return $this->ValidPeriodCode;
    }
    /**
     * Set ValidPeriodCode value
     * @param string $validPeriodCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setValidPeriodCode($validPeriodCode = null)
    {
        // validation for constraint: string
        if (!is_null($validPeriodCode) && !is_string($validPeriodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validPeriodCode, true), gettype($validPeriodCode)), __LINE__);
        }
        $this->ValidPeriodCode = $validPeriodCode;
        return $this;
    }
    /**
     * Get MnnCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMnnCode()
    {
        return isset($this->MnnCode) ? $this->MnnCode : null;
    }
    /**
     * Set MnnCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mnnCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setMnnCode($mnnCode = null)
    {
        // validation for constraint: int
        if (!is_null($mnnCode) && !(is_int($mnnCode) || ctype_digit($mnnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mnnCode, true), gettype($mnnCode)), __LINE__);
        }
        if (is_null($mnnCode) || (is_array($mnnCode) && empty($mnnCode))) {
            unset($this->MnnCode);
        } else {
            $this->MnnCode = $mnnCode;
        }
        return $this;
    }
    /**
     * Get TrnCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrnCode()
    {
        return isset($this->TrnCode) ? $this->TrnCode : null;
    }
    /**
     * Set TrnCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trnCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setTrnCode($trnCode = null)
    {
        // validation for constraint: int
        if (!is_null($trnCode) && !(is_int($trnCode) || ctype_digit($trnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trnCode, true), gettype($trnCode)), __LINE__);
        }
        if (is_null($trnCode) || (is_array($trnCode) && empty($trnCode))) {
            unset($this->TrnCode);
        } else {
            $this->TrnCode = $trnCode;
        }
        return $this;
    }
    /**
     * Get Dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->Dosage;
    }
    /**
     * Set Dosage value
     * @param string $dosage
     * @return \StructType\RecipeClient2Issue
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosage, true), gettype($dosage)), __LINE__);
        }
        $this->Dosage = $dosage;
        return $this;
    }
    /**
     * Get CureformCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCureformCode()
    {
        return isset($this->CureformCode) ? $this->CureformCode : null;
    }
    /**
     * Set CureformCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cureformCode
     * @return \StructType\RecipeClient2Issue
     */
    public function setCureformCode($cureformCode = null)
    {
        // validation for constraint: int
        if (!is_null($cureformCode) && !(is_int($cureformCode) || ctype_digit($cureformCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cureformCode, true), gettype($cureformCode)), __LINE__);
        }
        if (is_null($cureformCode) || (is_array($cureformCode) && empty($cureformCode))) {
            unset($this->CureformCode);
        } else {
            $this->CureformCode = $cureformCode;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \StructType\RecipeClient2Issue
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityAtom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityAtom()
    {
        return isset($this->QuantityAtom) ? $this->QuantityAtom : null;
    }
    /**
     * Set QuantityAtom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityAtom
     * @return \StructType\RecipeClient2Issue
     */
    public function setQuantityAtom($quantityAtom = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAtom) && !(is_int($quantityAtom) || ctype_digit($quantityAtom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAtom, true), gettype($quantityAtom)), __LINE__);
        }
        if (is_null($quantityAtom) || (is_array($quantityAtom) && empty($quantityAtom))) {
            unset($this->QuantityAtom);
        } else {
            $this->QuantityAtom = $quantityAtom;
        }
        return $this;
    }
}
