<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipeClient StructType
 * @subpackage Structs
 */
class RecipeClient extends Entity
{
    /**
     * The PatientFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PatientFound;
    /**
     * The LpuFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LpuFound;
    /**
     * The DoctorFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DoctorFound;
    /**
     * The MkbFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MkbFound;
    /**
     * The FundingSourceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FundingSourceCode;
    /**
     * The FundingSourceFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FundingSourceFound;
    /**
     * The NosologyFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NosologyFound;
    /**
     * The PrivilegeCodeFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PrivilegeCodeFound;
    /**
     * The ProgramFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ProgramFound;
    /**
     * The ValidPeriodFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ValidPeriodFound;
    /**
     * The PayPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayPercent;
    /**
     * The PayPercentFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PayPercentFound;
    /**
     * The IsTrn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTrn;
    /**
     * The TrnFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TrnFound;
    /**
     * The MnnFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MnnFound;
    /**
     * The CureformFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CureformFound;
    /**
     * The UnitFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UnitFound;
    /**
     * The IsVk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVk;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The Uploaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Uploaded;
    /**
     * The IsAnnulled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAnnulled;
    /**
     * The CauseOfAnnulmentFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CauseOfAnnulmentFound;
    /**
     * The QuantityAtom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QuantityAtom;
    /**
     * The OrderLpuGuidFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OrderLpuGuidFound;
    /**
     * The OrderLpuItemGuidFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OrderLpuItemGuidFound;
    /**
     * The IsSignedExternal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSignedExternal;
    /**
     * The Seria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seria;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Snils
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Snils;
    /**
     * The LpuOgrn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LpuOgrn;
    /**
     * The LpuFoms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LpuFoms;
    /**
     * The DoctorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorCode;
    /**
     * The MkbCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MkbCode;
    /**
     * The NosologyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NosologyCode;
    /**
     * The PrivilegeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrivilegeCode;
    /**
     * The ValidPeriodCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidPeriodCode;
    /**
     * The TrnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrnCode;
    /**
     * The MnnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MnnCode;
    /**
     * The CureformCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CureformCode;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The Dosage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dosage;
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaleDate;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The RecipeCheck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecipeCheck;
    /**
     * The CauseOfAnnulment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CauseOfAnnulment;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The OrderLpuGuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderLpuGuid;
    /**
     * The OrderLpuItemGuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderLpuItemGuid;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The SignAuthor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignAuthor;
    /**
     * The SignSN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignSN;
    /**
     * The SignValidTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignValidTo;
    /**
     * The StructId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StructId;
    /**
     * Constructor method for RecipeClient
     * @uses RecipeClient::setPatientFound()
     * @uses RecipeClient::setLpuFound()
     * @uses RecipeClient::setDoctorFound()
     * @uses RecipeClient::setMkbFound()
     * @uses RecipeClient::setFundingSourceCode()
     * @uses RecipeClient::setFundingSourceFound()
     * @uses RecipeClient::setNosologyFound()
     * @uses RecipeClient::setPrivilegeCodeFound()
     * @uses RecipeClient::setProgramFound()
     * @uses RecipeClient::setValidPeriodFound()
     * @uses RecipeClient::setPayPercent()
     * @uses RecipeClient::setPayPercentFound()
     * @uses RecipeClient::setIsTrn()
     * @uses RecipeClient::setTrnFound()
     * @uses RecipeClient::setMnnFound()
     * @uses RecipeClient::setCureformFound()
     * @uses RecipeClient::setUnitFound()
     * @uses RecipeClient::setIsVk()
     * @uses RecipeClient::setQuantity()
     * @uses RecipeClient::setUploaded()
     * @uses RecipeClient::setIsAnnulled()
     * @uses RecipeClient::setCauseOfAnnulmentFound()
     * @uses RecipeClient::setQuantityAtom()
     * @uses RecipeClient::setOrderLpuGuidFound()
     * @uses RecipeClient::setOrderLpuItemGuidFound()
     * @uses RecipeClient::setIsSignedExternal()
     * @uses RecipeClient::setSeria()
     * @uses RecipeClient::setNumber()
     * @uses RecipeClient::setSnils()
     * @uses RecipeClient::setLpuOgrn()
     * @uses RecipeClient::setLpuFoms()
     * @uses RecipeClient::setDoctorCode()
     * @uses RecipeClient::setMkbCode()
     * @uses RecipeClient::setNosologyCode()
     * @uses RecipeClient::setPrivilegeCode()
     * @uses RecipeClient::setValidPeriodCode()
     * @uses RecipeClient::setTrnCode()
     * @uses RecipeClient::setMnnCode()
     * @uses RecipeClient::setCureformCode()
     * @uses RecipeClient::setUnitCode()
     * @uses RecipeClient::setDosage()
     * @uses RecipeClient::setSaleDate()
     * @uses RecipeClient::setIssueDate()
     * @uses RecipeClient::setExpirationDate()
     * @uses RecipeClient::setRecipeCheck()
     * @uses RecipeClient::setCauseOfAnnulment()
     * @uses RecipeClient::setId()
     * @uses RecipeClient::setProgramName()
     * @uses RecipeClient::setOrderLpuGuid()
     * @uses RecipeClient::setOrderLpuItemGuid()
     * @uses RecipeClient::setProductCode()
     * @uses RecipeClient::setSignAuthor()
     * @uses RecipeClient::setSignSN()
     * @uses RecipeClient::setSignValidTo()
     * @uses RecipeClient::setStructId()
     * @param bool $patientFound
     * @param bool $lpuFound
     * @param bool $doctorFound
     * @param bool $mkbFound
     * @param int $fundingSourceCode
     * @param bool $fundingSourceFound
     * @param bool $nosologyFound
     * @param bool $privilegeCodeFound
     * @param bool $programFound
     * @param bool $validPeriodFound
     * @param int $payPercent
     * @param bool $payPercentFound
     * @param bool $isTrn
     * @param bool $trnFound
     * @param bool $mnnFound
     * @param bool $cureformFound
     * @param bool $unitFound
     * @param bool $isVk
     * @param float $quantity
     * @param bool $uploaded
     * @param bool $isAnnulled
     * @param bool $causeOfAnnulmentFound
     * @param float $quantityAtom
     * @param bool $orderLpuGuidFound
     * @param bool $orderLpuItemGuidFound
     * @param bool $isSignedExternal
     * @param string $seria
     * @param string $number
     * @param string $snils
     * @param string $lpuOgrn
     * @param string $lpuFoms
     * @param string $doctorCode
     * @param string $mkbCode
     * @param string $nosologyCode
     * @param string $privilegeCode
     * @param string $validPeriodCode
     * @param string $trnCode
     * @param string $mnnCode
     * @param string $cureformCode
     * @param string $unitCode
     * @param string $dosage
     * @param string $saleDate
     * @param string $issueDate
     * @param string $expirationDate
     * @param string $recipeCheck
     * @param string $causeOfAnnulment
     * @param string $id
     * @param string $programName
     * @param string $orderLpuGuid
     * @param string $orderLpuItemGuid
     * @param string $productCode
     * @param string $signAuthor
     * @param string $signSN
     * @param string $signValidTo
     * @param string $structId
     */
    public function __construct($patientFound = null, $lpuFound = null, $doctorFound = null, $mkbFound = null, $fundingSourceCode = null, $fundingSourceFound = null, $nosologyFound = null, $privilegeCodeFound = null, $programFound = null, $validPeriodFound = null, $payPercent = null, $payPercentFound = null, $isTrn = null, $trnFound = null, $mnnFound = null, $cureformFound = null, $unitFound = null, $isVk = null, $quantity = null, $uploaded = null, $isAnnulled = null, $causeOfAnnulmentFound = null, $quantityAtom = null, $orderLpuGuidFound = null, $orderLpuItemGuidFound = null, $isSignedExternal = null, $seria = null, $number = null, $snils = null, $lpuOgrn = null, $lpuFoms = null, $doctorCode = null, $mkbCode = null, $nosologyCode = null, $privilegeCode = null, $validPeriodCode = null, $trnCode = null, $mnnCode = null, $cureformCode = null, $unitCode = null, $dosage = null, $saleDate = null, $issueDate = null, $expirationDate = null, $recipeCheck = null, $causeOfAnnulment = null, $id = null, $programName = null, $orderLpuGuid = null, $orderLpuItemGuid = null, $productCode = null, $signAuthor = null, $signSN = null, $signValidTo = null, $structId = null)
    {
        $this
            ->setPatientFound($patientFound)
            ->setLpuFound($lpuFound)
            ->setDoctorFound($doctorFound)
            ->setMkbFound($mkbFound)
            ->setFundingSourceCode($fundingSourceCode)
            ->setFundingSourceFound($fundingSourceFound)
            ->setNosologyFound($nosologyFound)
            ->setPrivilegeCodeFound($privilegeCodeFound)
            ->setProgramFound($programFound)
            ->setValidPeriodFound($validPeriodFound)
            ->setPayPercent($payPercent)
            ->setPayPercentFound($payPercentFound)
            ->setIsTrn($isTrn)
            ->setTrnFound($trnFound)
            ->setMnnFound($mnnFound)
            ->setCureformFound($cureformFound)
            ->setUnitFound($unitFound)
            ->setIsVk($isVk)
            ->setQuantity($quantity)
            ->setUploaded($uploaded)
            ->setIsAnnulled($isAnnulled)
            ->setCauseOfAnnulmentFound($causeOfAnnulmentFound)
            ->setQuantityAtom($quantityAtom)
            ->setOrderLpuGuidFound($orderLpuGuidFound)
            ->setOrderLpuItemGuidFound($orderLpuItemGuidFound)
            ->setIsSignedExternal($isSignedExternal)
            ->setSeria($seria)
            ->setNumber($number)
            ->setSnils($snils)
            ->setLpuOgrn($lpuOgrn)
            ->setLpuFoms($lpuFoms)
            ->setDoctorCode($doctorCode)
            ->setMkbCode($mkbCode)
            ->setNosologyCode($nosologyCode)
            ->setPrivilegeCode($privilegeCode)
            ->setValidPeriodCode($validPeriodCode)
            ->setTrnCode($trnCode)
            ->setMnnCode($mnnCode)
            ->setCureformCode($cureformCode)
            ->setUnitCode($unitCode)
            ->setDosage($dosage)
            ->setSaleDate($saleDate)
            ->setIssueDate($issueDate)
            ->setExpirationDate($expirationDate)
            ->setRecipeCheck($recipeCheck)
            ->setCauseOfAnnulment($causeOfAnnulment)
            ->setId($id)
            ->setProgramName($programName)
            ->setOrderLpuGuid($orderLpuGuid)
            ->setOrderLpuItemGuid($orderLpuItemGuid)
            ->setProductCode($productCode)
            ->setSignAuthor($signAuthor)
            ->setSignSN($signSN)
            ->setSignValidTo($signValidTo)
            ->setStructId($structId);
    }
    /**
     * Get PatientFound value
     * @return bool
     */
    public function getPatientFound()
    {
        return $this->PatientFound;
    }
    /**
     * Set PatientFound value
     * @param bool $patientFound
     * @return \StructType\RecipeClient
     */
    public function setPatientFound($patientFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($patientFound) && !is_bool($patientFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($patientFound, true), gettype($patientFound)), __LINE__);
        }
        $this->PatientFound = $patientFound;
        return $this;
    }
    /**
     * Get LpuFound value
     * @return bool
     */
    public function getLpuFound()
    {
        return $this->LpuFound;
    }
    /**
     * Set LpuFound value
     * @param bool $lpuFound
     * @return \StructType\RecipeClient
     */
    public function setLpuFound($lpuFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($lpuFound) && !is_bool($lpuFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lpuFound, true), gettype($lpuFound)), __LINE__);
        }
        $this->LpuFound = $lpuFound;
        return $this;
    }
    /**
     * Get DoctorFound value
     * @return bool
     */
    public function getDoctorFound()
    {
        return $this->DoctorFound;
    }
    /**
     * Set DoctorFound value
     * @param bool $doctorFound
     * @return \StructType\RecipeClient
     */
    public function setDoctorFound($doctorFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($doctorFound) && !is_bool($doctorFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doctorFound, true), gettype($doctorFound)), __LINE__);
        }
        $this->DoctorFound = $doctorFound;
        return $this;
    }
    /**
     * Get MkbFound value
     * @return bool
     */
    public function getMkbFound()
    {
        return $this->MkbFound;
    }
    /**
     * Set MkbFound value
     * @param bool $mkbFound
     * @return \StructType\RecipeClient
     */
    public function setMkbFound($mkbFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($mkbFound) && !is_bool($mkbFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mkbFound, true), gettype($mkbFound)), __LINE__);
        }
        $this->MkbFound = $mkbFound;
        return $this;
    }
    /**
     * Get FundingSourceCode value
     * @return int
     */
    public function getFundingSourceCode()
    {
        return $this->FundingSourceCode;
    }
    /**
     * Set FundingSourceCode value
     * @param int $fundingSourceCode
     * @return \StructType\RecipeClient
     */
    public function setFundingSourceCode($fundingSourceCode = null)
    {
        // validation for constraint: int
        if (!is_null($fundingSourceCode) && !(is_int($fundingSourceCode) || ctype_digit($fundingSourceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fundingSourceCode, true), gettype($fundingSourceCode)), __LINE__);
        }
        $this->FundingSourceCode = $fundingSourceCode;
        return $this;
    }
    /**
     * Get FundingSourceFound value
     * @return bool
     */
    public function getFundingSourceFound()
    {
        return $this->FundingSourceFound;
    }
    /**
     * Set FundingSourceFound value
     * @param bool $fundingSourceFound
     * @return \StructType\RecipeClient
     */
    public function setFundingSourceFound($fundingSourceFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($fundingSourceFound) && !is_bool($fundingSourceFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fundingSourceFound, true), gettype($fundingSourceFound)), __LINE__);
        }
        $this->FundingSourceFound = $fundingSourceFound;
        return $this;
    }
    /**
     * Get NosologyFound value
     * @return bool
     */
    public function getNosologyFound()
    {
        return $this->NosologyFound;
    }
    /**
     * Set NosologyFound value
     * @param bool $nosologyFound
     * @return \StructType\RecipeClient
     */
    public function setNosologyFound($nosologyFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($nosologyFound) && !is_bool($nosologyFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nosologyFound, true), gettype($nosologyFound)), __LINE__);
        }
        $this->NosologyFound = $nosologyFound;
        return $this;
    }
    /**
     * Get PrivilegeCodeFound value
     * @return bool
     */
    public function getPrivilegeCodeFound()
    {
        return $this->PrivilegeCodeFound;
    }
    /**
     * Set PrivilegeCodeFound value
     * @param bool $privilegeCodeFound
     * @return \StructType\RecipeClient
     */
    public function setPrivilegeCodeFound($privilegeCodeFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($privilegeCodeFound) && !is_bool($privilegeCodeFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privilegeCodeFound, true), gettype($privilegeCodeFound)), __LINE__);
        }
        $this->PrivilegeCodeFound = $privilegeCodeFound;
        return $this;
    }
    /**
     * Get ProgramFound value
     * @return bool
     */
    public function getProgramFound()
    {
        return $this->ProgramFound;
    }
    /**
     * Set ProgramFound value
     * @param bool $programFound
     * @return \StructType\RecipeClient
     */
    public function setProgramFound($programFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($programFound) && !is_bool($programFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($programFound, true), gettype($programFound)), __LINE__);
        }
        $this->ProgramFound = $programFound;
        return $this;
    }
    /**
     * Get ValidPeriodFound value
     * @return bool
     */
    public function getValidPeriodFound()
    {
        return $this->ValidPeriodFound;
    }
    /**
     * Set ValidPeriodFound value
     * @param bool $validPeriodFound
     * @return \StructType\RecipeClient
     */
    public function setValidPeriodFound($validPeriodFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($validPeriodFound) && !is_bool($validPeriodFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validPeriodFound, true), gettype($validPeriodFound)), __LINE__);
        }
        $this->ValidPeriodFound = $validPeriodFound;
        return $this;
    }
    /**
     * Get PayPercent value
     * @return int
     */
    public function getPayPercent()
    {
        return $this->PayPercent;
    }
    /**
     * Set PayPercent value
     * @param int $payPercent
     * @return \StructType\RecipeClient
     */
    public function setPayPercent($payPercent = null)
    {
        // validation for constraint: int
        if (!is_null($payPercent) && !(is_int($payPercent) || ctype_digit($payPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payPercent, true), gettype($payPercent)), __LINE__);
        }
        $this->PayPercent = $payPercent;
        return $this;
    }
    /**
     * Get PayPercentFound value
     * @return bool
     */
    public function getPayPercentFound()
    {
        return $this->PayPercentFound;
    }
    /**
     * Set PayPercentFound value
     * @param bool $payPercentFound
     * @return \StructType\RecipeClient
     */
    public function setPayPercentFound($payPercentFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($payPercentFound) && !is_bool($payPercentFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payPercentFound, true), gettype($payPercentFound)), __LINE__);
        }
        $this->PayPercentFound = $payPercentFound;
        return $this;
    }
    /**
     * Get IsTrn value
     * @return bool
     */
    public function getIsTrn()
    {
        return $this->IsTrn;
    }
    /**
     * Set IsTrn value
     * @param bool $isTrn
     * @return \StructType\RecipeClient
     */
    public function setIsTrn($isTrn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTrn) && !is_bool($isTrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTrn, true), gettype($isTrn)), __LINE__);
        }
        $this->IsTrn = $isTrn;
        return $this;
    }
    /**
     * Get TrnFound value
     * @return bool
     */
    public function getTrnFound()
    {
        return $this->TrnFound;
    }
    /**
     * Set TrnFound value
     * @param bool $trnFound
     * @return \StructType\RecipeClient
     */
    public function setTrnFound($trnFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($trnFound) && !is_bool($trnFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trnFound, true), gettype($trnFound)), __LINE__);
        }
        $this->TrnFound = $trnFound;
        return $this;
    }
    /**
     * Get MnnFound value
     * @return bool
     */
    public function getMnnFound()
    {
        return $this->MnnFound;
    }
    /**
     * Set MnnFound value
     * @param bool $mnnFound
     * @return \StructType\RecipeClient
     */
    public function setMnnFound($mnnFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($mnnFound) && !is_bool($mnnFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mnnFound, true), gettype($mnnFound)), __LINE__);
        }
        $this->MnnFound = $mnnFound;
        return $this;
    }
    /**
     * Get CureformFound value
     * @return bool
     */
    public function getCureformFound()
    {
        return $this->CureformFound;
    }
    /**
     * Set CureformFound value
     * @param bool $cureformFound
     * @return \StructType\RecipeClient
     */
    public function setCureformFound($cureformFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($cureformFound) && !is_bool($cureformFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cureformFound, true), gettype($cureformFound)), __LINE__);
        }
        $this->CureformFound = $cureformFound;
        return $this;
    }
    /**
     * Get UnitFound value
     * @return bool
     */
    public function getUnitFound()
    {
        return $this->UnitFound;
    }
    /**
     * Set UnitFound value
     * @param bool $unitFound
     * @return \StructType\RecipeClient
     */
    public function setUnitFound($unitFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($unitFound) && !is_bool($unitFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unitFound, true), gettype($unitFound)), __LINE__);
        }
        $this->UnitFound = $unitFound;
        return $this;
    }
    /**
     * Get IsVk value
     * @return bool
     */
    public function getIsVk()
    {
        return $this->IsVk;
    }
    /**
     * Set IsVk value
     * @param bool $isVk
     * @return \StructType\RecipeClient
     */
    public function setIsVk($isVk = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVk) && !is_bool($isVk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVk, true), gettype($isVk)), __LINE__);
        }
        $this->IsVk = $isVk;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\RecipeClient
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Uploaded value
     * @return bool
     */
    public function getUploaded()
    {
        return $this->Uploaded;
    }
    /**
     * Set Uploaded value
     * @param bool $uploaded
     * @return \StructType\RecipeClient
     */
    public function setUploaded($uploaded = null)
    {
        // validation for constraint: boolean
        if (!is_null($uploaded) && !is_bool($uploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uploaded, true), gettype($uploaded)), __LINE__);
        }
        $this->Uploaded = $uploaded;
        return $this;
    }
    /**
     * Get IsAnnulled value
     * @return bool
     */
    public function getIsAnnulled()
    {
        return $this->IsAnnulled;
    }
    /**
     * Set IsAnnulled value
     * @param bool $isAnnulled
     * @return \StructType\RecipeClient
     */
    public function setIsAnnulled($isAnnulled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnnulled) && !is_bool($isAnnulled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnnulled, true), gettype($isAnnulled)), __LINE__);
        }
        $this->IsAnnulled = $isAnnulled;
        return $this;
    }
    /**
     * Get CauseOfAnnulmentFound value
     * @return bool
     */
    public function getCauseOfAnnulmentFound()
    {
        return $this->CauseOfAnnulmentFound;
    }
    /**
     * Set CauseOfAnnulmentFound value
     * @param bool $causeOfAnnulmentFound
     * @return \StructType\RecipeClient
     */
    public function setCauseOfAnnulmentFound($causeOfAnnulmentFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($causeOfAnnulmentFound) && !is_bool($causeOfAnnulmentFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($causeOfAnnulmentFound, true), gettype($causeOfAnnulmentFound)), __LINE__);
        }
        $this->CauseOfAnnulmentFound = $causeOfAnnulmentFound;
        return $this;
    }
    /**
     * Get QuantityAtom value
     * @return float
     */
    public function getQuantityAtom()
    {
        return $this->QuantityAtom;
    }
    /**
     * Set QuantityAtom value
     * @param float $quantityAtom
     * @return \StructType\RecipeClient
     */
    public function setQuantityAtom($quantityAtom = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAtom) && !(is_float($quantityAtom) || is_numeric($quantityAtom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAtom, true), gettype($quantityAtom)), __LINE__);
        }
        $this->QuantityAtom = $quantityAtom;
        return $this;
    }
    /**
     * Get OrderLpuGuidFound value
     * @return bool
     */
    public function getOrderLpuGuidFound()
    {
        return $this->OrderLpuGuidFound;
    }
    /**
     * Set OrderLpuGuidFound value
     * @param bool $orderLpuGuidFound
     * @return \StructType\RecipeClient
     */
    public function setOrderLpuGuidFound($orderLpuGuidFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderLpuGuidFound) && !is_bool($orderLpuGuidFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderLpuGuidFound, true), gettype($orderLpuGuidFound)), __LINE__);
        }
        $this->OrderLpuGuidFound = $orderLpuGuidFound;
        return $this;
    }
    /**
     * Get OrderLpuItemGuidFound value
     * @return bool
     */
    public function getOrderLpuItemGuidFound()
    {
        return $this->OrderLpuItemGuidFound;
    }
    /**
     * Set OrderLpuItemGuidFound value
     * @param bool $orderLpuItemGuidFound
     * @return \StructType\RecipeClient
     */
    public function setOrderLpuItemGuidFound($orderLpuItemGuidFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderLpuItemGuidFound) && !is_bool($orderLpuItemGuidFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderLpuItemGuidFound, true), gettype($orderLpuItemGuidFound)), __LINE__);
        }
        $this->OrderLpuItemGuidFound = $orderLpuItemGuidFound;
        return $this;
    }
    /**
     * Get IsSignedExternal value
     * @return bool
     */
    public function getIsSignedExternal()
    {
        return $this->IsSignedExternal;
    }
    /**
     * Set IsSignedExternal value
     * @param bool $isSignedExternal
     * @return \StructType\RecipeClient
     */
    public function setIsSignedExternal($isSignedExternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSignedExternal) && !is_bool($isSignedExternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSignedExternal, true), gettype($isSignedExternal)), __LINE__);
        }
        $this->IsSignedExternal = $isSignedExternal;
        return $this;
    }
    /**
     * Get Seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->Seria;
    }
    /**
     * Set Seria value
     * @param string $seria
     * @return \StructType\RecipeClient
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->Seria = $seria;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\RecipeClient
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->Snils;
    }
    /**
     * Set Snils value
     * @param string $snils
     * @return \StructType\RecipeClient
     */
    public function setSnils($snils = null)
    {
        // validation for constraint: string
        if (!is_null($snils) && !is_string($snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snils, true), gettype($snils)), __LINE__);
        }
        $this->Snils = $snils;
        return $this;
    }
    /**
     * Get LpuOgrn value
     * @return string|null
     */
    public function getLpuOgrn()
    {
        return $this->LpuOgrn;
    }
    /**
     * Set LpuOgrn value
     * @param string $lpuOgrn
     * @return \StructType\RecipeClient
     */
    public function setLpuOgrn($lpuOgrn = null)
    {
        // validation for constraint: string
        if (!is_null($lpuOgrn) && !is_string($lpuOgrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lpuOgrn, true), gettype($lpuOgrn)), __LINE__);
        }
        $this->LpuOgrn = $lpuOgrn;
        return $this;
    }
    /**
     * Get LpuFoms value
     * @return string|null
     */
    public function getLpuFoms()
    {
        return $this->LpuFoms;
    }
    /**
     * Set LpuFoms value
     * @param string $lpuFoms
     * @return \StructType\RecipeClient
     */
    public function setLpuFoms($lpuFoms = null)
    {
        // validation for constraint: string
        if (!is_null($lpuFoms) && !is_string($lpuFoms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lpuFoms, true), gettype($lpuFoms)), __LINE__);
        }
        $this->LpuFoms = $lpuFoms;
        return $this;
    }
    /**
     * Get DoctorCode value
     * @return string|null
     */
    public function getDoctorCode()
    {
        return $this->DoctorCode;
    }
    /**
     * Set DoctorCode value
     * @param string $doctorCode
     * @return \StructType\RecipeClient
     */
    public function setDoctorCode($doctorCode = null)
    {
        // validation for constraint: string
        if (!is_null($doctorCode) && !is_string($doctorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorCode, true), gettype($doctorCode)), __LINE__);
        }
        $this->DoctorCode = $doctorCode;
        return $this;
    }
    /**
     * Get MkbCode value
     * @return string|null
     */
    public function getMkbCode()
    {
        return $this->MkbCode;
    }
    /**
     * Set MkbCode value
     * @param string $mkbCode
     * @return \StructType\RecipeClient
     */
    public function setMkbCode($mkbCode = null)
    {
        // validation for constraint: string
        if (!is_null($mkbCode) && !is_string($mkbCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mkbCode, true), gettype($mkbCode)), __LINE__);
        }
        $this->MkbCode = $mkbCode;
        return $this;
    }
    /**
     * Get NosologyCode value
     * @return string|null
     */
    public function getNosologyCode()
    {
        return $this->NosologyCode;
    }
    /**
     * Set NosologyCode value
     * @param string $nosologyCode
     * @return \StructType\RecipeClient
     */
    public function setNosologyCode($nosologyCode = null)
    {
        // validation for constraint: string
        if (!is_null($nosologyCode) && !is_string($nosologyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nosologyCode, true), gettype($nosologyCode)), __LINE__);
        }
        $this->NosologyCode = $nosologyCode;
        return $this;
    }
    /**
     * Get PrivilegeCode value
     * @return string|null
     */
    public function getPrivilegeCode()
    {
        return $this->PrivilegeCode;
    }
    /**
     * Set PrivilegeCode value
     * @param string $privilegeCode
     * @return \StructType\RecipeClient
     */
    public function setPrivilegeCode($privilegeCode = null)
    {
        // validation for constraint: string
        if (!is_null($privilegeCode) && !is_string($privilegeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privilegeCode, true), gettype($privilegeCode)), __LINE__);
        }
        $this->PrivilegeCode = $privilegeCode;
        return $this;
    }
    /**
     * Get ValidPeriodCode value
     * @return string|null
     */
    public function getValidPeriodCode()
    {
        return $this->ValidPeriodCode;
    }
    /**
     * Set ValidPeriodCode value
     * @param string $validPeriodCode
     * @return \StructType\RecipeClient
     */
    public function setValidPeriodCode($validPeriodCode = null)
    {
        // validation for constraint: string
        if (!is_null($validPeriodCode) && !is_string($validPeriodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validPeriodCode, true), gettype($validPeriodCode)), __LINE__);
        }
        $this->ValidPeriodCode = $validPeriodCode;
        return $this;
    }
    /**
     * Get TrnCode value
     * @return string|null
     */
    public function getTrnCode()
    {
        return $this->TrnCode;
    }
    /**
     * Set TrnCode value
     * @param string $trnCode
     * @return \StructType\RecipeClient
     */
    public function setTrnCode($trnCode = null)
    {
        // validation for constraint: string
        if (!is_null($trnCode) && !is_string($trnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trnCode, true), gettype($trnCode)), __LINE__);
        }
        $this->TrnCode = $trnCode;
        return $this;
    }
    /**
     * Get MnnCode value
     * @return string|null
     */
    public function getMnnCode()
    {
        return $this->MnnCode;
    }
    /**
     * Set MnnCode value
     * @param string $mnnCode
     * @return \StructType\RecipeClient
     */
    public function setMnnCode($mnnCode = null)
    {
        // validation for constraint: string
        if (!is_null($mnnCode) && !is_string($mnnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mnnCode, true), gettype($mnnCode)), __LINE__);
        }
        $this->MnnCode = $mnnCode;
        return $this;
    }
    /**
     * Get CureformCode value
     * @return string|null
     */
    public function getCureformCode()
    {
        return $this->CureformCode;
    }
    /**
     * Set CureformCode value
     * @param string $cureformCode
     * @return \StructType\RecipeClient
     */
    public function setCureformCode($cureformCode = null)
    {
        // validation for constraint: string
        if (!is_null($cureformCode) && !is_string($cureformCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cureformCode, true), gettype($cureformCode)), __LINE__);
        }
        $this->CureformCode = $cureformCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\RecipeClient
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get Dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->Dosage;
    }
    /**
     * Set Dosage value
     * @param string $dosage
     * @return \StructType\RecipeClient
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosage, true), gettype($dosage)), __LINE__);
        }
        $this->Dosage = $dosage;
        return $this;
    }
    /**
     * Get SaleDate value
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->SaleDate;
    }
    /**
     * Set SaleDate value
     * @param string $saleDate
     * @return \StructType\RecipeClient
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        $this->SaleDate = $saleDate;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\RecipeClient
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\RecipeClient
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get RecipeCheck value
     * @return string|null
     */
    public function getRecipeCheck()
    {
        return $this->RecipeCheck;
    }
    /**
     * Set RecipeCheck value
     * @param string $recipeCheck
     * @return \StructType\RecipeClient
     */
    public function setRecipeCheck($recipeCheck = null)
    {
        // validation for constraint: string
        if (!is_null($recipeCheck) && !is_string($recipeCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipeCheck, true), gettype($recipeCheck)), __LINE__);
        }
        $this->RecipeCheck = $recipeCheck;
        return $this;
    }
    /**
     * Get CauseOfAnnulment value
     * @return string|null
     */
    public function getCauseOfAnnulment()
    {
        return $this->CauseOfAnnulment;
    }
    /**
     * Set CauseOfAnnulment value
     * @param string $causeOfAnnulment
     * @return \StructType\RecipeClient
     */
    public function setCauseOfAnnulment($causeOfAnnulment = null)
    {
        // validation for constraint: string
        if (!is_null($causeOfAnnulment) && !is_string($causeOfAnnulment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causeOfAnnulment, true), gettype($causeOfAnnulment)), __LINE__);
        }
        $this->CauseOfAnnulment = $causeOfAnnulment;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RecipeClient
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\RecipeClient
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get OrderLpuGuid value
     * @return string|null
     */
    public function getOrderLpuGuid()
    {
        return $this->OrderLpuGuid;
    }
    /**
     * Set OrderLpuGuid value
     * @param string $orderLpuGuid
     * @return \StructType\RecipeClient
     */
    public function setOrderLpuGuid($orderLpuGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orderLpuGuid) && !is_string($orderLpuGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderLpuGuid, true), gettype($orderLpuGuid)), __LINE__);
        }
        $this->OrderLpuGuid = $orderLpuGuid;
        return $this;
    }
    /**
     * Get OrderLpuItemGuid value
     * @return string|null
     */
    public function getOrderLpuItemGuid()
    {
        return $this->OrderLpuItemGuid;
    }
    /**
     * Set OrderLpuItemGuid value
     * @param string $orderLpuItemGuid
     * @return \StructType\RecipeClient
     */
    public function setOrderLpuItemGuid($orderLpuItemGuid = null)
    {
        // validation for constraint: string
        if (!is_null($orderLpuItemGuid) && !is_string($orderLpuItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderLpuItemGuid, true), gettype($orderLpuItemGuid)), __LINE__);
        }
        $this->OrderLpuItemGuid = $orderLpuItemGuid;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\RecipeClient
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get SignAuthor value
     * @return string|null
     */
    public function getSignAuthor()
    {
        return $this->SignAuthor;
    }
    /**
     * Set SignAuthor value
     * @param string $signAuthor
     * @return \StructType\RecipeClient
     */
    public function setSignAuthor($signAuthor = null)
    {
        // validation for constraint: string
        if (!is_null($signAuthor) && !is_string($signAuthor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signAuthor, true), gettype($signAuthor)), __LINE__);
        }
        $this->SignAuthor = $signAuthor;
        return $this;
    }
    /**
     * Get SignSN value
     * @return string|null
     */
    public function getSignSN()
    {
        return $this->SignSN;
    }
    /**
     * Set SignSN value
     * @param string $signSN
     * @return \StructType\RecipeClient
     */
    public function setSignSN($signSN = null)
    {
        // validation for constraint: string
        if (!is_null($signSN) && !is_string($signSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signSN, true), gettype($signSN)), __LINE__);
        }
        $this->SignSN = $signSN;
        return $this;
    }
    /**
     * Get SignValidTo value
     * @return string|null
     */
    public function getSignValidTo()
    {
        return $this->SignValidTo;
    }
    /**
     * Set SignValidTo value
     * @param string $signValidTo
     * @return \StructType\RecipeClient
     */
    public function setSignValidTo($signValidTo = null)
    {
        // validation for constraint: string
        if (!is_null($signValidTo) && !is_string($signValidTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signValidTo, true), gettype($signValidTo)), __LINE__);
        }
        $this->SignValidTo = $signValidTo;
        return $this;
    }
    /**
     * Get StructId value
     * @return string|null
     */
    public function getStructId()
    {
        return $this->StructId;
    }
    /**
     * Set StructId value
     * @param string $structId
     * @return \StructType\RecipeClient
     */
    public function setStructId($structId = null)
    {
        // validation for constraint: string
        if (!is_null($structId) && !is_string($structId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($structId, true), gettype($structId)), __LINE__);
        }
        $this->StructId = $structId;
        return $this;
    }
}
