<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LpuRecipePdfData StructType
 * @subpackage Structs
 */
class LpuRecipePdfData extends Entity
{
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filename;
    /**
     * The Filebody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filebody;
    /**
     * The FileMd5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileMd5;
    /**
     * Constructor method for LpuRecipePdfData
     * @uses LpuRecipePdfData::setFilename()
     * @uses LpuRecipePdfData::setFilebody()
     * @uses LpuRecipePdfData::setFileMd5()
     * @param string $filename
     * @param string $filebody
     * @param string $fileMd5
     */
    public function __construct($filename = null, $filebody = null, $fileMd5 = null)
    {
        $this
            ->setFilename($filename)
            ->setFilebody($filebody)
            ->setFileMd5($fileMd5);
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\LpuRecipePdfData
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Filebody value
     * @return string|null
     */
    public function getFilebody()
    {
        return $this->Filebody;
    }
    /**
     * Set Filebody value
     * @param string $filebody
     * @return \StructType\LpuRecipePdfData
     */
    public function setFilebody($filebody = null)
    {
        // validation for constraint: string
        if (!is_null($filebody) && !is_string($filebody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filebody, true), gettype($filebody)), __LINE__);
        }
        $this->Filebody = $filebody;
        return $this;
    }
    /**
     * Get FileMd5 value
     * @return string|null
     */
    public function getFileMd5()
    {
        return $this->FileMd5;
    }
    /**
     * Set FileMd5 value
     * @param string $fileMd5
     * @return \StructType\LpuRecipePdfData
     */
    public function setFileMd5($fileMd5 = null)
    {
        // validation for constraint: string
        if (!is_null($fileMd5) && !is_string($fileMd5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileMd5, true), gettype($fileMd5)), __LINE__);
        }
        $this->FileMd5 = $fileMd5;
        return $this;
    }
}
