<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LpuRecipe StructType
 * @subpackage Structs
 */
class LpuRecipe extends Entity
{
    /**
     * The Okato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Okato;
    /**
     * The CategoryType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryType;
    /**
     * The PayPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayPercent;
    /**
     * The QuantityUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantityUnit;
    /**
     * The QuantityAtom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantityAtom;
    /**
     * The ScalingRatio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScalingRatio;
    /**
     * The PackageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageSize;
    /**
     * The IsSigned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSigned;
    /**
     * The Bad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Bad;
    /**
     * The RecipeSeria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecipeSeria;
    /**
     * The RecipeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecipeNumber;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The DoctorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DoctorCode;
    /**
     * The Ogrn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ogrn;
    /**
     * The Mcod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mcod;
    /**
     * The Snils
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Snils;
    /**
     * The IndividualCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualCode;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthDate;
    /**
     * The Sex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sex;
    /**
     * The PolicySeries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PolicySeries;
    /**
     * The PolicyNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PolicyNumber;
    /**
     * The PrivilegeCategoryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrivilegeCategoryCode;
    /**
     * The FundingSourceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FundingSourceCode;
    /**
     * The ValidPeriodCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidPeriodCode;
    /**
     * The MkbCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MkbCode;
    /**
     * The TrnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrnCode;
    /**
     * The MnnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MnnCode;
    /**
     * The CureformCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CureformCode;
    /**
     * The Dosage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dosage;
    /**
     * The Signa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signa;
    /**
     * The PdfData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LpuRecipePdfData[]
     */
    public $PdfData;
    /**
     * The SignatureData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LpuRecipeSignatureData[]
     */
    public $SignatureData;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMsg;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for LpuRecipe
     * @uses LpuRecipe::setOkato()
     * @uses LpuRecipe::setCategoryType()
     * @uses LpuRecipe::setPayPercent()
     * @uses LpuRecipe::setQuantityUnit()
     * @uses LpuRecipe::setQuantityAtom()
     * @uses LpuRecipe::setScalingRatio()
     * @uses LpuRecipe::setPackageSize()
     * @uses LpuRecipe::setIsSigned()
     * @uses LpuRecipe::setBad()
     * @uses LpuRecipe::setRecipeSeria()
     * @uses LpuRecipe::setRecipeNumber()
     * @uses LpuRecipe::setIssueDate()
     * @uses LpuRecipe::setDoctorCode()
     * @uses LpuRecipe::setOgrn()
     * @uses LpuRecipe::setMcod()
     * @uses LpuRecipe::setSnils()
     * @uses LpuRecipe::setIndividualCode()
     * @uses LpuRecipe::setBirthDate()
     * @uses LpuRecipe::setSex()
     * @uses LpuRecipe::setPolicySeries()
     * @uses LpuRecipe::setPolicyNumber()
     * @uses LpuRecipe::setPrivilegeCategoryCode()
     * @uses LpuRecipe::setFundingSourceCode()
     * @uses LpuRecipe::setValidPeriodCode()
     * @uses LpuRecipe::setMkbCode()
     * @uses LpuRecipe::setTrnCode()
     * @uses LpuRecipe::setMnnCode()
     * @uses LpuRecipe::setCureformCode()
     * @uses LpuRecipe::setDosage()
     * @uses LpuRecipe::setSigna()
     * @uses LpuRecipe::setPdfData()
     * @uses LpuRecipe::setSignatureData()
     * @uses LpuRecipe::setErrorMsg()
     * @uses LpuRecipe::setId()
     * @param int $okato
     * @param int $categoryType
     * @param int $payPercent
     * @param int $quantityUnit
     * @param int $quantityAtom
     * @param int $scalingRatio
     * @param int $packageSize
     * @param bool $isSigned
     * @param bool $bad
     * @param string $recipeSeria
     * @param string $recipeNumber
     * @param string $issueDate
     * @param string $doctorCode
     * @param string $ogrn
     * @param string $mcod
     * @param string $snils
     * @param string $individualCode
     * @param string $birthDate
     * @param string $sex
     * @param string $policySeries
     * @param string $policyNumber
     * @param string $privilegeCategoryCode
     * @param string $fundingSourceCode
     * @param string $validPeriodCode
     * @param string $mkbCode
     * @param string $trnCode
     * @param string $mnnCode
     * @param string $cureformCode
     * @param string $dosage
     * @param string $signa
     * @param \StructType\LpuRecipePdfData[] $pdfData
     * @param \StructType\LpuRecipeSignatureData[] $signatureData
     * @param string $errorMsg
     * @param string $id
     */
    public function __construct($okato = null, $categoryType = null, $payPercent = null, $quantityUnit = null, $quantityAtom = null, $scalingRatio = null, $packageSize = null, $isSigned = null, $bad = null, $recipeSeria = null, $recipeNumber = null, $issueDate = null, $doctorCode = null, $ogrn = null, $mcod = null, $snils = null, $individualCode = null, $birthDate = null, $sex = null, $policySeries = null, $policyNumber = null, $privilegeCategoryCode = null, $fundingSourceCode = null, $validPeriodCode = null, $mkbCode = null, $trnCode = null, $mnnCode = null, $cureformCode = null, $dosage = null, $signa = null, array $pdfData = array(), array $signatureData = array(), $errorMsg = null, $id = null)
    {
        $this
            ->setOkato($okato)
            ->setCategoryType($categoryType)
            ->setPayPercent($payPercent)
            ->setQuantityUnit($quantityUnit)
            ->setQuantityAtom($quantityAtom)
            ->setScalingRatio($scalingRatio)
            ->setPackageSize($packageSize)
            ->setIsSigned($isSigned)
            ->setBad($bad)
            ->setRecipeSeria($recipeSeria)
            ->setRecipeNumber($recipeNumber)
            ->setIssueDate($issueDate)
            ->setDoctorCode($doctorCode)
            ->setOgrn($ogrn)
            ->setMcod($mcod)
            ->setSnils($snils)
            ->setIndividualCode($individualCode)
            ->setBirthDate($birthDate)
            ->setSex($sex)
            ->setPolicySeries($policySeries)
            ->setPolicyNumber($policyNumber)
            ->setPrivilegeCategoryCode($privilegeCategoryCode)
            ->setFundingSourceCode($fundingSourceCode)
            ->setValidPeriodCode($validPeriodCode)
            ->setMkbCode($mkbCode)
            ->setTrnCode($trnCode)
            ->setMnnCode($mnnCode)
            ->setCureformCode($cureformCode)
            ->setDosage($dosage)
            ->setSigna($signa)
            ->setPdfData($pdfData)
            ->setSignatureData($signatureData)
            ->setErrorMsg($errorMsg)
            ->setId($id);
    }
    /**
     * Get Okato value
     * @return int
     */
    public function getOkato()
    {
        return $this->Okato;
    }
    /**
     * Set Okato value
     * @param int $okato
     * @return \StructType\LpuRecipe
     */
    public function setOkato($okato = null)
    {
        // validation for constraint: int
        if (!is_null($okato) && !(is_int($okato) || ctype_digit($okato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($okato, true), gettype($okato)), __LINE__);
        }
        $this->Okato = $okato;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return int
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param int $categoryType
     * @return \StructType\LpuRecipe
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: int
        if (!is_null($categoryType) && !(is_int($categoryType) || ctype_digit($categoryType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryType, true), gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get PayPercent value
     * @return int
     */
    public function getPayPercent()
    {
        return $this->PayPercent;
    }
    /**
     * Set PayPercent value
     * @param int $payPercent
     * @return \StructType\LpuRecipe
     */
    public function setPayPercent($payPercent = null)
    {
        // validation for constraint: int
        if (!is_null($payPercent) && !(is_int($payPercent) || ctype_digit($payPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payPercent, true), gettype($payPercent)), __LINE__);
        }
        $this->PayPercent = $payPercent;
        return $this;
    }
    /**
     * Get QuantityUnit value
     * @return int
     */
    public function getQuantityUnit()
    {
        return $this->QuantityUnit;
    }
    /**
     * Set QuantityUnit value
     * @param int $quantityUnit
     * @return \StructType\LpuRecipe
     */
    public function setQuantityUnit($quantityUnit = null)
    {
        // validation for constraint: int
        if (!is_null($quantityUnit) && !(is_int($quantityUnit) || ctype_digit($quantityUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityUnit, true), gettype($quantityUnit)), __LINE__);
        }
        $this->QuantityUnit = $quantityUnit;
        return $this;
    }
    /**
     * Get QuantityAtom value
     * @return int
     */
    public function getQuantityAtom()
    {
        return $this->QuantityAtom;
    }
    /**
     * Set QuantityAtom value
     * @param int $quantityAtom
     * @return \StructType\LpuRecipe
     */
    public function setQuantityAtom($quantityAtom = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAtom) && !(is_int($quantityAtom) || ctype_digit($quantityAtom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAtom, true), gettype($quantityAtom)), __LINE__);
        }
        $this->QuantityAtom = $quantityAtom;
        return $this;
    }
    /**
     * Get ScalingRatio value
     * @return int
     */
    public function getScalingRatio()
    {
        return $this->ScalingRatio;
    }
    /**
     * Set ScalingRatio value
     * @param int $scalingRatio
     * @return \StructType\LpuRecipe
     */
    public function setScalingRatio($scalingRatio = null)
    {
        // validation for constraint: int
        if (!is_null($scalingRatio) && !(is_int($scalingRatio) || ctype_digit($scalingRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scalingRatio, true), gettype($scalingRatio)), __LINE__);
        }
        $this->ScalingRatio = $scalingRatio;
        return $this;
    }
    /**
     * Get PackageSize value
     * @return int
     */
    public function getPackageSize()
    {
        return $this->PackageSize;
    }
    /**
     * Set PackageSize value
     * @param int $packageSize
     * @return \StructType\LpuRecipe
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !(is_int($packageSize) || ctype_digit($packageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageSize, true), gettype($packageSize)), __LINE__);
        }
        $this->PackageSize = $packageSize;
        return $this;
    }
    /**
     * Get IsSigned value
     * @return bool
     */
    public function getIsSigned()
    {
        return $this->IsSigned;
    }
    /**
     * Set IsSigned value
     * @param bool $isSigned
     * @return \StructType\LpuRecipe
     */
    public function setIsSigned($isSigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSigned) && !is_bool($isSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSigned, true), gettype($isSigned)), __LINE__);
        }
        $this->IsSigned = $isSigned;
        return $this;
    }
    /**
     * Get Bad value
     * @return bool
     */
    public function getBad()
    {
        return $this->Bad;
    }
    /**
     * Set Bad value
     * @param bool $bad
     * @return \StructType\LpuRecipe
     */
    public function setBad($bad = null)
    {
        // validation for constraint: boolean
        if (!is_null($bad) && !is_bool($bad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bad, true), gettype($bad)), __LINE__);
        }
        $this->Bad = $bad;
        return $this;
    }
    /**
     * Get RecipeSeria value
     * @return string|null
     */
    public function getRecipeSeria()
    {
        return $this->RecipeSeria;
    }
    /**
     * Set RecipeSeria value
     * @param string $recipeSeria
     * @return \StructType\LpuRecipe
     */
    public function setRecipeSeria($recipeSeria = null)
    {
        // validation for constraint: string
        if (!is_null($recipeSeria) && !is_string($recipeSeria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipeSeria, true), gettype($recipeSeria)), __LINE__);
        }
        $this->RecipeSeria = $recipeSeria;
        return $this;
    }
    /**
     * Get RecipeNumber value
     * @return string|null
     */
    public function getRecipeNumber()
    {
        return $this->RecipeNumber;
    }
    /**
     * Set RecipeNumber value
     * @param string $recipeNumber
     * @return \StructType\LpuRecipe
     */
    public function setRecipeNumber($recipeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($recipeNumber) && !is_string($recipeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipeNumber, true), gettype($recipeNumber)), __LINE__);
        }
        $this->RecipeNumber = $recipeNumber;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\LpuRecipe
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DoctorCode value
     * @return string|null
     */
    public function getDoctorCode()
    {
        return $this->DoctorCode;
    }
    /**
     * Set DoctorCode value
     * @param string $doctorCode
     * @return \StructType\LpuRecipe
     */
    public function setDoctorCode($doctorCode = null)
    {
        // validation for constraint: string
        if (!is_null($doctorCode) && !is_string($doctorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doctorCode, true), gettype($doctorCode)), __LINE__);
        }
        $this->DoctorCode = $doctorCode;
        return $this;
    }
    /**
     * Get Ogrn value
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->Ogrn;
    }
    /**
     * Set Ogrn value
     * @param string $ogrn
     * @return \StructType\LpuRecipe
     */
    public function setOgrn($ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($ogrn) && !is_string($ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ogrn, true), gettype($ogrn)), __LINE__);
        }
        $this->Ogrn = $ogrn;
        return $this;
    }
    /**
     * Get Mcod value
     * @return string|null
     */
    public function getMcod()
    {
        return $this->Mcod;
    }
    /**
     * Set Mcod value
     * @param string $mcod
     * @return \StructType\LpuRecipe
     */
    public function setMcod($mcod = null)
    {
        // validation for constraint: string
        if (!is_null($mcod) && !is_string($mcod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mcod, true), gettype($mcod)), __LINE__);
        }
        $this->Mcod = $mcod;
        return $this;
    }
    /**
     * Get Snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->Snils;
    }
    /**
     * Set Snils value
     * @param string $snils
     * @return \StructType\LpuRecipe
     */
    public function setSnils($snils = null)
    {
        // validation for constraint: string
        if (!is_null($snils) && !is_string($snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snils, true), gettype($snils)), __LINE__);
        }
        $this->Snils = $snils;
        return $this;
    }
    /**
     * Get IndividualCode value
     * @return string|null
     */
    public function getIndividualCode()
    {
        return $this->IndividualCode;
    }
    /**
     * Set IndividualCode value
     * @param string $individualCode
     * @return \StructType\LpuRecipe
     */
    public function setIndividualCode($individualCode = null)
    {
        // validation for constraint: string
        if (!is_null($individualCode) && !is_string($individualCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualCode, true), gettype($individualCode)), __LINE__);
        }
        $this->IndividualCode = $individualCode;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\LpuRecipe
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Sex value
     * @return string|null
     */
    public function getSex()
    {
        return $this->Sex;
    }
    /**
     * Set Sex value
     * @param string $sex
     * @return \StructType\LpuRecipe
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        $this->Sex = $sex;
        return $this;
    }
    /**
     * Get PolicySeries value
     * @return string|null
     */
    public function getPolicySeries()
    {
        return $this->PolicySeries;
    }
    /**
     * Set PolicySeries value
     * @param string $policySeries
     * @return \StructType\LpuRecipe
     */
    public function setPolicySeries($policySeries = null)
    {
        // validation for constraint: string
        if (!is_null($policySeries) && !is_string($policySeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policySeries, true), gettype($policySeries)), __LINE__);
        }
        $this->PolicySeries = $policySeries;
        return $this;
    }
    /**
     * Get PolicyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->PolicyNumber;
    }
    /**
     * Set PolicyNumber value
     * @param string $policyNumber
     * @return \StructType\LpuRecipe
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->PolicyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get PrivilegeCategoryCode value
     * @return string|null
     */
    public function getPrivilegeCategoryCode()
    {
        return $this->PrivilegeCategoryCode;
    }
    /**
     * Set PrivilegeCategoryCode value
     * @param string $privilegeCategoryCode
     * @return \StructType\LpuRecipe
     */
    public function setPrivilegeCategoryCode($privilegeCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($privilegeCategoryCode) && !is_string($privilegeCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privilegeCategoryCode, true), gettype($privilegeCategoryCode)), __LINE__);
        }
        $this->PrivilegeCategoryCode = $privilegeCategoryCode;
        return $this;
    }
    /**
     * Get FundingSourceCode value
     * @return string|null
     */
    public function getFundingSourceCode()
    {
        return $this->FundingSourceCode;
    }
    /**
     * Set FundingSourceCode value
     * @param string $fundingSourceCode
     * @return \StructType\LpuRecipe
     */
    public function setFundingSourceCode($fundingSourceCode = null)
    {
        // validation for constraint: string
        if (!is_null($fundingSourceCode) && !is_string($fundingSourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundingSourceCode, true), gettype($fundingSourceCode)), __LINE__);
        }
        $this->FundingSourceCode = $fundingSourceCode;
        return $this;
    }
    /**
     * Get ValidPeriodCode value
     * @return string|null
     */
    public function getValidPeriodCode()
    {
        return $this->ValidPeriodCode;
    }
    /**
     * Set ValidPeriodCode value
     * @param string $validPeriodCode
     * @return \StructType\LpuRecipe
     */
    public function setValidPeriodCode($validPeriodCode = null)
    {
        // validation for constraint: string
        if (!is_null($validPeriodCode) && !is_string($validPeriodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validPeriodCode, true), gettype($validPeriodCode)), __LINE__);
        }
        $this->ValidPeriodCode = $validPeriodCode;
        return $this;
    }
    /**
     * Get MkbCode value
     * @return string|null
     */
    public function getMkbCode()
    {
        return $this->MkbCode;
    }
    /**
     * Set MkbCode value
     * @param string $mkbCode
     * @return \StructType\LpuRecipe
     */
    public function setMkbCode($mkbCode = null)
    {
        // validation for constraint: string
        if (!is_null($mkbCode) && !is_string($mkbCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mkbCode, true), gettype($mkbCode)), __LINE__);
        }
        $this->MkbCode = $mkbCode;
        return $this;
    }
    /**
     * Get TrnCode value
     * @return string|null
     */
    public function getTrnCode()
    {
        return $this->TrnCode;
    }
    /**
     * Set TrnCode value
     * @param string $trnCode
     * @return \StructType\LpuRecipe
     */
    public function setTrnCode($trnCode = null)
    {
        // validation for constraint: string
        if (!is_null($trnCode) && !is_string($trnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trnCode, true), gettype($trnCode)), __LINE__);
        }
        $this->TrnCode = $trnCode;
        return $this;
    }
    /**
     * Get MnnCode value
     * @return string|null
     */
    public function getMnnCode()
    {
        return $this->MnnCode;
    }
    /**
     * Set MnnCode value
     * @param string $mnnCode
     * @return \StructType\LpuRecipe
     */
    public function setMnnCode($mnnCode = null)
    {
        // validation for constraint: string
        if (!is_null($mnnCode) && !is_string($mnnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mnnCode, true), gettype($mnnCode)), __LINE__);
        }
        $this->MnnCode = $mnnCode;
        return $this;
    }
    /**
     * Get CureformCode value
     * @return string|null
     */
    public function getCureformCode()
    {
        return $this->CureformCode;
    }
    /**
     * Set CureformCode value
     * @param string $cureformCode
     * @return \StructType\LpuRecipe
     */
    public function setCureformCode($cureformCode = null)
    {
        // validation for constraint: string
        if (!is_null($cureformCode) && !is_string($cureformCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cureformCode, true), gettype($cureformCode)), __LINE__);
        }
        $this->CureformCode = $cureformCode;
        return $this;
    }
    /**
     * Get Dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->Dosage;
    }
    /**
     * Set Dosage value
     * @param string $dosage
     * @return \StructType\LpuRecipe
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosage, true), gettype($dosage)), __LINE__);
        }
        $this->Dosage = $dosage;
        return $this;
    }
    /**
     * Get Signa value
     * @return string|null
     */
    public function getSigna()
    {
        return $this->Signa;
    }
    /**
     * Set Signa value
     * @param string $signa
     * @return \StructType\LpuRecipe
     */
    public function setSigna($signa = null)
    {
        // validation for constraint: string
        if (!is_null($signa) && !is_string($signa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signa, true), gettype($signa)), __LINE__);
        }
        $this->Signa = $signa;
        return $this;
    }
    /**
     * Get PdfData value
     * @return \StructType\LpuRecipePdfData[]|null
     */
    public function getPdfData()
    {
        return $this->PdfData;
    }
    /**
     * This method is responsible for validating the values passed to the setPdfData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPdfData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePdfDataForArrayConstraintsFromSetPdfData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lpuRecipePdfDataItem) {
            // validation for constraint: itemType
            if (!$lpuRecipePdfDataItem instanceof \StructType\LpuRecipePdfData) {
                $invalidValues[] = is_object($lpuRecipePdfDataItem) ? get_class($lpuRecipePdfDataItem) : sprintf('%s(%s)', gettype($lpuRecipePdfDataItem), var_export($lpuRecipePdfDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PdfData property can only contain items of type \StructType\LpuRecipePdfData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PdfData value
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipePdfData[] $pdfData
     * @return \StructType\LpuRecipe
     */
    public function setPdfData(array $pdfData = array())
    {
        // validation for constraint: array
        if ('' !== ($pdfDataArrayErrorMessage = self::validatePdfDataForArrayConstraintsFromSetPdfData($pdfData))) {
            throw new \InvalidArgumentException($pdfDataArrayErrorMessage, __LINE__);
        }
        $this->PdfData = $pdfData;
        return $this;
    }
    /**
     * Add item to PdfData value
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipePdfData $item
     * @return \StructType\LpuRecipe
     */
    public function addToPdfData(\StructType\LpuRecipePdfData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LpuRecipePdfData) {
            throw new \InvalidArgumentException(sprintf('The PdfData property can only contain items of type \StructType\LpuRecipePdfData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PdfData[] = $item;
        return $this;
    }
    /**
     * Get SignatureData value
     * @return \StructType\LpuRecipeSignatureData[]|null
     */
    public function getSignatureData()
    {
        return $this->SignatureData;
    }
    /**
     * This method is responsible for validating the values passed to the setSignatureData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignatureData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatureDataForArrayConstraintsFromSetSignatureData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lpuRecipeSignatureDataItem) {
            // validation for constraint: itemType
            if (!$lpuRecipeSignatureDataItem instanceof \StructType\LpuRecipeSignatureData) {
                $invalidValues[] = is_object($lpuRecipeSignatureDataItem) ? get_class($lpuRecipeSignatureDataItem) : sprintf('%s(%s)', gettype($lpuRecipeSignatureDataItem), var_export($lpuRecipeSignatureDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SignatureData property can only contain items of type \StructType\LpuRecipeSignatureData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SignatureData value
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipeSignatureData[] $signatureData
     * @return \StructType\LpuRecipe
     */
    public function setSignatureData(array $signatureData = array())
    {
        // validation for constraint: array
        if ('' !== ($signatureDataArrayErrorMessage = self::validateSignatureDataForArrayConstraintsFromSetSignatureData($signatureData))) {
            throw new \InvalidArgumentException($signatureDataArrayErrorMessage, __LINE__);
        }
        $this->SignatureData = $signatureData;
        return $this;
    }
    /**
     * Add item to SignatureData value
     * @throws \InvalidArgumentException
     * @param \StructType\LpuRecipeSignatureData $item
     * @return \StructType\LpuRecipe
     */
    public function addToSignatureData(\StructType\LpuRecipeSignatureData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LpuRecipeSignatureData) {
            throw new \InvalidArgumentException(sprintf('The SignatureData property can only contain items of type \StructType\LpuRecipeSignatureData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SignatureData[] = $item;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \StructType\LpuRecipe
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\LpuRecipe
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
