<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recipes ServiceType
 * @subpackage Services
 */
class Recipes extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecipesClientSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipesClientSave $parameters
     * @return \StructType\RecipesClientSaveResponse|bool
     */
    public function RecipesClientSave(\StructType\RecipesClientSave $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipesClientSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipesClient2Save
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipesClient2Save $parameters
     * @return \StructType\RecipesClient2SaveResponse|bool
     */
    public function RecipesClient2Save(\StructType\RecipesClient2Save $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipesClient2Save($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecipesClientHashesExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecipesClientHashesExchange $parameters
     * @return \StructType\RecipesClientHashesExchangeResponse|bool
     */
    public function RecipesClientHashesExchange(\StructType\RecipesClientHashesExchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecipesClientHashesExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RecipesClient2SaveResponse|\StructType\RecipesClientHashesExchangeResponse|\StructType\RecipesClientSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
