<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lpu ServiceType
 * @subpackage Services
 */
class Lpu extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LpuRecipeRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LpuRecipeRequest $parameters
     * @return \StructType\LpuRecipeRequestResponse|bool
     */
    public function LpuRecipeRequest(\StructType\LpuRecipeRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LpuRecipeRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LpuRecipeRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
