<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecipe ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRecipe
 * @subpackage Arrays
 */
class ArrayOfRecipe extends AbstractStructArrayBase
{
    /**
     * The Recipe
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Recipe[]
     */
    public $Recipe;
    /**
     * Constructor method for ArrayOfRecipe
     * @uses ArrayOfRecipe::setRecipe()
     * @param \StructType\Recipe[] $recipe
     */
    public function __construct(array $recipe = array())
    {
        $this
            ->setRecipe($recipe);
    }
    /**
     * Get Recipe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Recipe[]|null
     */
    public function getRecipe()
    {
        return isset($this->Recipe) ? $this->Recipe : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipeForArrayConstraintsFromSetRecipe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecipeRecipeItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecipeRecipeItem instanceof \StructType\Recipe) {
                $invalidValues[] = is_object($arrayOfRecipeRecipeItem) ? get_class($arrayOfRecipeRecipeItem) : sprintf('%s(%s)', gettype($arrayOfRecipeRecipeItem), var_export($arrayOfRecipeRecipeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recipe property can only contain items of type \StructType\Recipe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recipe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Recipe[] $recipe
     * @return \ArrayType\ArrayOfRecipe
     */
    public function setRecipe(array $recipe = array())
    {
        // validation for constraint: array
        if ('' !== ($recipeArrayErrorMessage = self::validateRecipeForArrayConstraintsFromSetRecipe($recipe))) {
            throw new \InvalidArgumentException($recipeArrayErrorMessage, __LINE__);
        }
        if (is_null($recipe) || (is_array($recipe) && empty($recipe))) {
            unset($this->Recipe);
        } else {
            $this->Recipe = $recipe;
        }
        return $this;
    }
    /**
     * Add item to Recipe value
     * @throws \InvalidArgumentException
     * @param \StructType\Recipe $item
     * @return \ArrayType\ArrayOfRecipe
     */
    public function addToRecipe(\StructType\Recipe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recipe) {
            throw new \InvalidArgumentException(sprintf('The Recipe property can only contain items of type \StructType\Recipe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recipe[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Recipe|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Recipe|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Recipe|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Recipe|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Recipe|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Recipe
     */
    public function getAttributeName()
    {
        return 'Recipe';
    }
}
