<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMnnItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfMnnItem extends AbstractStructArrayBase
{
    /**
     * The MnnItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MnnItem[]
     */
    public $MnnItem;
    /**
     * Constructor method for ArrayOfMnnItem
     * @uses ArrayOfMnnItem::setMnnItem()
     * @param \StructType\MnnItem[] $mnnItem
     */
    public function __construct(array $mnnItem = array())
    {
        $this
            ->setMnnItem($mnnItem);
    }
    /**
     * Get MnnItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MnnItem[]|null
     */
    public function getMnnItem()
    {
        return isset($this->MnnItem) ? $this->MnnItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMnnItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMnnItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMnnItemForArrayConstraintsFromSetMnnItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMnnItemMnnItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfMnnItemMnnItemItem instanceof \StructType\MnnItem) {
                $invalidValues[] = is_object($arrayOfMnnItemMnnItemItem) ? get_class($arrayOfMnnItemMnnItemItem) : sprintf('%s(%s)', gettype($arrayOfMnnItemMnnItemItem), var_export($arrayOfMnnItemMnnItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MnnItem property can only contain items of type \StructType\MnnItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MnnItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MnnItem[] $mnnItem
     * @return \ArrayType\ArrayOfMnnItem
     */
    public function setMnnItem(array $mnnItem = array())
    {
        // validation for constraint: array
        if ('' !== ($mnnItemArrayErrorMessage = self::validateMnnItemForArrayConstraintsFromSetMnnItem($mnnItem))) {
            throw new \InvalidArgumentException($mnnItemArrayErrorMessage, __LINE__);
        }
        if (is_null($mnnItem) || (is_array($mnnItem) && empty($mnnItem))) {
            unset($this->MnnItem);
        } else {
            $this->MnnItem = $mnnItem;
        }
        return $this;
    }
    /**
     * Add item to MnnItem value
     * @throws \InvalidArgumentException
     * @param \StructType\MnnItem $item
     * @return \ArrayType\ArrayOfMnnItem
     */
    public function addToMnnItem(\StructType\MnnItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MnnItem) {
            throw new \InvalidArgumentException(sprintf('The MnnItem property can only contain items of type \StructType\MnnItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MnnItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MnnItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MnnItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MnnItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MnnItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MnnItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MnnItem
     */
    public function getAttributeName()
    {
        return 'MnnItem';
    }
}
